"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.App = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
require("./app.scss");
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
var _i18nReact = require("@kbn/i18n-react");
var _cluster_address_form = require("./cluster_address_form");
var _cluster_configuration_form = require("./cluster_configuration_form");
var _enrollment_token_form = require("./enrollment_token_form");
var _progress_indicator = require("./progress_indicator");
var _use_kibana = require("./use_kibana");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const App = ({
  onSuccess
}) => {
  const [page, setPage] = (0, _react.useState)('token');
  const [cluster, setCluster] = (0, _react.useState)();
  const {
    http
  } = (0, _use_kibana.useKibana)();
  const state = (0, _useAsync.default)(() => http.get('/internal/interactive_setup/status'), [http]);
  if (state.loading) {
    return null;
  }
  if (!state.value || state.value.connectionStatus === 'configured' || !state.value.isSetupOnHold) {
    return /*#__PURE__*/_react.default.createElement("pre", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "interactiveSetup.app.notReady",
      defaultMessage: "Kibana server is not ready yet."
    }));
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "interactiveSetup"
  }, /*#__PURE__*/_react.default.createElement("header", {
    className: "interactiveSetup__header eui-textCenter"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl"
  }), /*#__PURE__*/_react.default.createElement("span", {
    className: "interactiveSetup__logo"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "logoElastic",
    size: "xxl"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h1", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "interactiveSetup.app.pageTitle",
    defaultMessage: "Configure Elastic to get started"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  })), /*#__PURE__*/_react.default.createElement("div", {
    className: "interactiveSetup__content"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "l"
  }, /*#__PURE__*/_react.default.createElement("div", {
    hidden: page !== 'token'
  }, /*#__PURE__*/_react.default.createElement(_enrollment_token_form.EnrollmentTokenForm, {
    onCancel: () => setPage('manual'),
    onSuccess: () => setPage('success')
  })), /*#__PURE__*/_react.default.createElement("div", {
    hidden: page !== 'manual'
  }, cluster ? /*#__PURE__*/_react.default.createElement(_cluster_configuration_form.ClusterConfigurationForm, (0, _extends2.default)({
    onCancel: () => setCluster(undefined),
    onSuccess: () => setPage('success')
  }, cluster)) : /*#__PURE__*/_react.default.createElement(_cluster_address_form.ClusterAddressForm, {
    onCancel: () => setPage('token'),
    onSuccess: (result, values) => setCluster({
      host: values.host,
      authRequired: result.authRequired,
      certificateChain: result.certificateChain
    })
  })), page === 'success' && /*#__PURE__*/_react.default.createElement(_progress_indicator.ProgressIndicator, {
    onSuccess: onSuccess
  }))));
};
exports.App = App;