"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RequestCodeViewer = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _monaco = require("@kbn/monaco");
var _lzString = require("lz-string");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

// We want to allow both right-clicking to open in a new tab and clicking through
// the "Open in Console" link. We could use `RedirectAppLinks` at the top level
// but that inserts a div which messes up the layout of the inspector.
/* eslint-disable @elastic/eui/href-or-on-click */

const copyToClipboardLabel = _i18n.i18n.translate('inspector.requests.copyToClipboardLabel', {
  defaultMessage: 'Copy to clipboard'
});
const openInConsoleLabel = _i18n.i18n.translate('inspector.requests.openInConsoleLabel', {
  defaultMessage: 'Open in Console'
});
const openInSearchProfilerLabel = _i18n.i18n.translate('inspector.requests.openInSearchProfilerLabel', {
  defaultMessage: 'Open in Search Profiler'
});

/**
 * @internal
 */
const RequestCodeViewer = ({
  indexPattern,
  json
}) => {
  var _services$application, _services$share$url$l, _services$application2, _services$application3, _services$share$url$l2, _services$application4, _services$application5;
  const {
    services
  } = (0, _public.useKibana)();
  const navigateToUrl = (_services$application = services.application) === null || _services$application === void 0 ? void 0 : _services$application.navigateToUrl;
  const devToolsDataUri = (0, _lzString.compressToEncodedURIComponent)(`GET ${indexPattern}/_search\n${json}`);
  const consoleHref = (_services$share$url$l = services.share.url.locators.get('CONSOLE_APP_LOCATOR')) === null || _services$share$url$l === void 0 ? void 0 : _services$share$url$l.useUrl({
    loadFrom: `data:text/plain,${devToolsDataUri}`
  });
  // Check if both the Dev Tools UI and the Console UI are enabled.
  const canShowDevTools = ((_services$application2 = services.application) === null || _services$application2 === void 0 ? void 0 : (_services$application3 = _services$application2.capabilities) === null || _services$application3 === void 0 ? void 0 : _services$application3.dev_tools.show) && consoleHref !== undefined;
  const shouldShowDevToolsLink = !!(indexPattern && canShowDevTools);
  const handleDevToolsLinkClick = (0, _react.useCallback)(() => consoleHref && navigateToUrl && navigateToUrl(consoleHref), [consoleHref, navigateToUrl]);
  const searchProfilerDataUri = (0, _lzString.compressToEncodedURIComponent)(json);
  const searchProfilerHref = (_services$share$url$l2 = services.share.url.locators.get('SEARCH_PROFILER_LOCATOR')) === null || _services$share$url$l2 === void 0 ? void 0 : _services$share$url$l2.useUrl({
    index: indexPattern,
    loadFrom: `data:text/plain,${searchProfilerDataUri}`
  });
  // Check if both the Dev Tools UI and the SearchProfiler UI are enabled.
  const canShowsearchProfiler = ((_services$application4 = services.application) === null || _services$application4 === void 0 ? void 0 : (_services$application5 = _services$application4.capabilities) === null || _services$application5 === void 0 ? void 0 : _services$application5.dev_tools.show) && searchProfilerHref !== undefined;
  const shouldShowsearchProfilerLink = !!(indexPattern && canShowsearchProfiler);
  const handleSearchProfilerLinkClick = (0, _react.useCallback)(() => searchProfilerHref && navigateToUrl && navigateToUrl(searchProfilerHref), [searchProfilerHref, navigateToUrl]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    wrap: false,
    responsive: false,
    className: "insRequestCodeViewer"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    gutterSize: "m",
    wrap: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
    textToCopy: json
  }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    flush: "right",
    iconType: "copyClipboard",
    onClick: copy,
    "data-test-subj": "inspectorRequestCopyClipboardButton"
  }, copyToClipboardLabel)))), shouldShowDevToolsLink && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    flush: "right",
    iconType: "wrench",
    href: consoleHref,
    onClick: handleDevToolsLinkClick,
    "data-test-subj": "inspectorRequestOpenInConsoleButton"
  }, openInConsoleLabel))), shouldShowsearchProfilerLink && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    flush: "right",
    iconType: "visBarHorizontal",
    href: searchProfilerHref,
    onClick: handleSearchProfilerLinkClick,
    "data-test-subj": "inspectorRequestOpenInSearchProfilerButton"
  }, openInSearchProfilerLabel))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    "data-test-subj": "inspectorRequestCodeViewerContainer"
  }, /*#__PURE__*/_react.default.createElement(_public.CodeEditor, {
    languageId: _monaco.XJsonLang.ID,
    value: json,
    options: {
      readOnly: true,
      lineNumbers: 'off',
      fontSize: 12,
      minimap: {
        enabled: false
      },
      folding: true,
      scrollBeyondLastLine: false,
      wordWrap: 'on',
      wrappingIndent: 'indent',
      automaticLayout: true
    }
  })));
};
exports.RequestCodeViewer = RequestCodeViewer;