"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InspectorPanel = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
require("./inspector_panel.scss");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _inspector_view_chooser = require("./inspector_view_chooser");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function hasAdaptersChanged(oldAdapters, newAdapters) {
  return Object.keys(oldAdapters).length !== Object.keys(newAdapters).length || Object.keys(oldAdapters).some(key => oldAdapters[key] !== newAdapters[key]);
}
const inspectorTitle = _i18n.i18n.translate('inspector.title', {
  defaultMessage: 'Inspector'
});
class InspectorPanel extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      selectedView: this.props.views[0],
      views: this.props.views,
      // Clone adapters array so we can validate that this prop never change
      adapters: {
        ...this.props.adapters
      }
    });
    (0, _defineProperty2.default)(this, "onViewSelected", view => {
      if (view !== this.state.selectedView) {
        this.setState({
          selectedView: view
        });
      }
    });
  }
  static getDerivedStateFromProps(nextProps, prevState) {
    if (hasAdaptersChanged(prevState.adapters, nextProps.adapters)) {
      throw new Error('Adapters are not allowed to be changed on an open InspectorPanel.');
    }
    const selectedViewMustChange = nextProps.views !== prevState.views && !nextProps.views.includes(prevState.selectedView);
    return {
      views: nextProps.views,
      selectedView: selectedViewMustChange ? nextProps.views[0] : prevState.selectedView
    };
  }
  renderSelectedPanel() {
    return /*#__PURE__*/_react.default.createElement(_react.Suspense, {
      fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null)
    }, /*#__PURE__*/_react.default.createElement(this.state.selectedView.component, {
      adapters: this.props.adapters,
      title: this.props.title || '',
      options: this.props.options
    }));
  }
  render() {
    const {
      views,
      title,
      dependencies
    } = this.props;
    const {
      selectedView
    } = this.state;
    return /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
      services: dependencies
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
      hasBorder: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h1", null, title))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_inspector_view_chooser.InspectorViewChooser, {
      views: views,
      onViewSelected: this.onViewSelected,
      selectedView: selectedView
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
      className: "insInspectorPanel__flyoutBody"
    }, this.renderSelectedPanel()));
  }
}
exports.InspectorPanel = InspectorPanel;
(0, _defineProperty2.default)(InspectorPanel, "defaultProps", {
  title: inspectorTitle
});
(0, _defineProperty2.default)(InspectorPanel, "propTypes", {
  adapters: _propTypes.default.object.isRequired,
  views: (props, propName, componentName) => {
    if (!Array.isArray(props.views) || props.views.length < 1) {
      throw new Error(`${propName} prop must be an array of at least one element in ${componentName}.`);
    }
  },
  title: _propTypes.default.string,
  options: _propTypes.default.object
});