"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLineageMap = getLineageMap;
var _lodash = _interopRequireDefault(require("lodash"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function getLineageMap(controlParamsList) {
  function getControlParamsById(controlId) {
    return controlParamsList.find(controlParams => {
      return controlParams.id === controlId;
    });
  }
  const lineageMap = new Map();
  controlParamsList.forEach(rootControlParams => {
    const lineage = [rootControlParams.id];
    const getLineage = controlParams => {
      if (_lodash.default.has(controlParams, 'parent') && controlParams.parent !== '' && !lineage.includes(controlParams.parent)) {
        lineage.push(controlParams.parent);
        const parent = getControlParamsById(controlParams.parent);
        if (parent) {
          getLineage(parent);
        }
      }
    };
    getLineage(rootControlParams);
    lineageMap.set(rootControlParams.id, lineage);
  });
  return lineageMap;
}