"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RangeControl = void 0;
exports.rangeControlFactory = rangeControlFactory;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = _interopRequireDefault(require("lodash"));
var _i18n = require("@kbn/i18n");
var _control = require("./control");
var _range_filter_manager = require("./filter_manager/range_filter_manager");
var _create_search_source = require("./create_search_source");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const minMaxAgg = field => {
  const aggBody = {};
  if (field) {
    if (field.scripted) {
      aggBody.script = {
        source: field.script,
        lang: field.lang
      };
    } else {
      aggBody.field = field.name;
    }
  }
  return {
    maxAgg: {
      max: aggBody
    },
    minAgg: {
      min: aggBody
    }
  };
};
class RangeControl extends _control.Control {
  constructor(controlParams, filterManager, useTimeFilter, searchSource, deps) {
    super(controlParams, filterManager, useTimeFilter);
    (0, _defineProperty2.default)(this, "searchSource", void 0);
    (0, _defineProperty2.default)(this, "timefilter", void 0);
    (0, _defineProperty2.default)(this, "abortController", void 0);
    (0, _defineProperty2.default)(this, "min", void 0);
    (0, _defineProperty2.default)(this, "max", void 0);
    this.timefilter = deps.data.query.timefilter.timefilter;
    this.searchSource = searchSource;
  }
  async fetch() {
    // Abort any in-progress fetch
    if (this.abortController) {
      this.abortController.abort();
    }
    this.abortController = new AbortController();
    const indexPattern = this.filterManager.getIndexPattern();
    if (!indexPattern) {
      this.disable((0, _control.noIndexPatternMsg)(this.controlParams.indexPattern));
      return;
    }
    const fieldName = this.filterManager.fieldName;
    const aggs = minMaxAgg(indexPattern.fields.getByName(fieldName));
    const searchSource = await (0, _create_search_source.createSearchSource)(this.searchSource, null, indexPattern, aggs, this.useTimeFilter, [], this.timefilter);
    const abortSignal = this.abortController.signal;
    let resp;
    try {
      resp = await searchSource.fetch({
        abortSignal
      });
    } catch (error) {
      // If the fetch was aborted then no need to surface this error in the UI
      if (error.name === 'AbortError') return;
      this.disable(_i18n.i18n.translate('inputControl.rangeControl.unableToFetchTooltip', {
        defaultMessage: 'Unable to fetch range min and max, error: {errorMessage}',
        values: {
          errorMessage: error.message
        }
      }));
      return;
    }
    const min = _lodash.default.get(resp, 'aggregations.minAgg.value', null);
    const max = _lodash.default.get(resp, 'aggregations.maxAgg.value', null);
    if (min === null || max === null) {
      this.disable((0, _control.noValuesDisableMsg)(fieldName, indexPattern.title));
      return;
    }
    this.min = min;
    this.max = max;
    this.enable = true;
  }
  destroy() {
    if (this.abortController) this.abortController.abort();
  }
}
exports.RangeControl = RangeControl;
async function rangeControlFactory(controlParams, useTimeFilter, deps) {
  const [, {
    data: dataPluginStart
  }] = await deps.core.getStartServices();
  const rangeControl = new RangeControl(controlParams, new _range_filter_manager.RangeFilterManager(controlParams.id, controlParams.fieldName, controlParams.indexPattern, dataPluginStart.indexPatterns, deps.data.query.filterManager), useTimeFilter, dataPluginStart.search.searchSource, deps);
  await rangeControl.filterManager.init();
  return rangeControl;
}