"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createSearchSource = createSearchSource;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

async function createSearchSource({
  create
}, initialState, indexPattern, aggs, useTimeFilter, filters = [], timefilter) {
  const searchSource = await create(initialState || {});

  // Do not not inherit from rootSearchSource to avoid picking up time and globals
  searchSource.setParent(undefined);
  searchSource.setField('filter', () => {
    const activeFilters = [...filters];
    if (useTimeFilter) {
      const filter = timefilter.createFilter(indexPattern);
      if (filter) {
        activeFilters.push(filter);
      }
    }
    return activeFilters;
  });
  searchSource.setField('size', 0);
  searchSource.setField('index', indexPattern);
  searchSource.setField('aggs', aggs);
  return searchSource;
}