"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IngestPipelinesPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _constants = require("../common/constants");
var _services = require("./application/services");
var _locator = require("./locator");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
class IngestPipelinesPlugin {
  constructor() {
    (0, _defineProperty2.default)(this, "license", null);
    (0, _defineProperty2.default)(this, "licensingSubscription", void 0);
  }
  setup(coreSetup, plugins) {
    const {
      management,
      usageCollection,
      share
    } = plugins;
    const {
      http,
      getStartServices
    } = coreSetup;

    // Initialize services
    _services.uiMetricService.setup(usageCollection);
    _services.apiService.setup(http, _services.uiMetricService);
    const pluginName = _i18n.i18n.translate('xpack.ingestPipelines.appTitle', {
      defaultMessage: 'Ingest Pipelines'
    });
    management.sections.section.ingest.registerApp({
      id: _constants.PLUGIN_ID,
      order: 1,
      title: pluginName,
      mount: async params => {
        const [coreStart] = await getStartServices();
        const {
          chrome: {
            docTitle
          }
        } = coreStart;
        docTitle.change(pluginName);
        const {
          mountManagementSection
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./application/mount_management_section')));
        const unmountAppCallback = await mountManagementSection(coreSetup, {
          ...params,
          license: this.license
        });
        return () => {
          docTitle.reset();
          unmountAppCallback();
        };
      }
    });
    share.url.locators.create(new _locator.IngestPipelinesLocatorDefinition({
      managementAppLocator: management.locator
    }));
  }
  start(core, {
    licensing
  }) {
    this.licensingSubscription = licensing === null || licensing === void 0 ? void 0 : licensing.license$.subscribe(license => {
      this.license = license;
    });
  }
  stop() {
    var _this$licensingSubscr;
    (_this$licensingSubscr = this.licensingSubscription) === null || _this$licensingSubscr === void 0 ? void 0 : _this$licensingSubscr.unsubscribe();
  }
}
exports.IngestPipelinesPlugin = IngestPipelinesPlugin;