"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PipelinesList = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _queryString = require("query-string");
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../shared_imports");
var _constants = require("../../constants");
var _navigation = require("../../services/navigation");
var _empty_list = require("./empty_list");
var _table = require("./table");
var _details_flyout = require("./details_flyout");
var _not_found_flyout = require("./not_found_flyout");
var _delete_modal = require("./delete_modal");
var _hooks = require("../../hooks");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getPipelineNameFromLocation = location => {
  const {
    pipeline
  } = (0, _queryString.parse)(location.search.substring(1));
  return pipeline;
};
const PipelinesList = ({
  history,
  location
}) => {
  const {
    services
  } = (0, _shared_imports.useKibana)();
  const pipelineNameFromLocation = getPipelineNameFromLocation(location);
  const [selectedPipeline, setSelectedPipeline] = (0, _react.useState)(undefined);
  const [showFlyout, setShowFlyout] = (0, _react.useState)(false);
  const [pipelinesToDelete, setPipelinesToDelete] = (0, _react.useState)([]);
  const {
    data,
    isLoading,
    error,
    resendRequest
  } = services.api.useLoadPipelines();
  const redirectToPathOrRedirectPath = (0, _hooks.useRedirectToPathOrRedirectPath)(history);

  // Track component loaded
  (0, _react.useEffect)(() => {
    services.metric.trackUiMetric(_constants.UIM_PIPELINES_LIST_LOAD);
    services.breadcrumbs.setBreadcrumbs('home');
  }, [services.metric, services.breadcrumbs]);
  (0, _react.useEffect)(() => {
    if (pipelineNameFromLocation && data !== null && data !== void 0 && data.length) {
      const pipeline = data.find(p => p.name === pipelineNameFromLocation);
      setSelectedPipeline(pipeline);
      setShowFlyout(true);
    }
  }, [pipelineNameFromLocation, data]);
  const goToEditPipeline = pipelineName => {
    history.push((0, _navigation.getEditPath)({
      pipelineName
    }));
  };
  const goToClonePipeline = clonedPipelineName => {
    history.push((0, _navigation.getClonePath)({
      clonedPipelineName
    }));
  };
  const goHome = () => {
    setShowFlyout(false);
    redirectToPathOrRedirectPath((0, _navigation.getListPath)());
  };
  if (error) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPageContent_Deprecated, {
      verticalPosition: "center",
      horizontalPosition: "center",
      color: "danger"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      iconType: "warning",
      title: /*#__PURE__*/_react.default.createElement("h2", {
        "data-test-subj": "pipelineLoadError"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ingestPipelines.list.loadErrorTitle",
        defaultMessage: "Unable to load pipelines"
      })),
      body: /*#__PURE__*/_react.default.createElement("p", null, error.message),
      actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        onClick: resendRequest,
        iconType: "refresh",
        color: "danger"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ingestPipelines.list.loadPipelineReloadButton",
        defaultMessage: "Try again"
      }))
    }));
  }
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPageContent_Deprecated, {
      verticalPosition: "center",
      horizontalPosition: "center",
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement(_shared_imports.SectionLoading, {
      "data-test-subj": "sectionLoading"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.list.loadingMessage",
      defaultMessage: "Loading pipelines..."
    })));
  }
  if (data && data.length === 0) {
    return /*#__PURE__*/_react.default.createElement(_empty_list.EmptyList, null);
  }
  const renderFlyout = () => {
    if (!showFlyout) {
      return;
    }
    if (selectedPipeline) {
      return /*#__PURE__*/_react.default.createElement(_details_flyout.PipelineDetailsFlyout, {
        pipeline: selectedPipeline,
        onClose: () => {
          setSelectedPipeline(undefined);
          goHome();
        },
        onEditClick: goToEditPipeline,
        onCloneClick: goToClonePipeline,
        onDeleteClick: setPipelinesToDelete
      });
    } else {
      // Somehow we triggered show pipeline details, but do not have a pipeline.
      // We assume not found.
      return /*#__PURE__*/_react.default.createElement(_not_found_flyout.PipelineNotFoundFlyout, {
        onClose: goHome,
        pipelineName: pipelineNameFromLocation
      });
    }
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    bottomBorder: true,
    pageTitle: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "appTitle"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.list.listTitle",
      defaultMessage: "Ingest Pipelines"
    })),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.list.pipelinesDescription",
      defaultMessage: "Use pipelines to remove or transform fields, extract values from text, and enrich your data before indexing."
    }),
    rightSideItems: [/*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      href: services.documentation.getIngestNodeUrl(),
      target: "_blank",
      iconType: "help",
      "data-test-subj": "documentationLink"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.list.pipelinesDocsLinkText",
      defaultMessage: "Ingest Pipelines docs"
    }))]
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_table.PipelineTable, {
    onReloadClick: resendRequest,
    onEditPipelineClick: goToEditPipeline,
    onDeletePipelineClick: setPipelinesToDelete,
    onClonePipelineClick: goToClonePipeline,
    pipelines: data
  }), renderFlyout(), (pipelinesToDelete === null || pipelinesToDelete === void 0 ? void 0 : pipelinesToDelete.length) > 0 ? /*#__PURE__*/_react.default.createElement(_delete_modal.PipelineDeleteModal, {
    callback: deleteResponse => {
      if (deleteResponse !== null && deleteResponse !== void 0 && deleteResponse.hasDeletedPipelines) {
        // reload pipelines list
        resendRequest();
        setSelectedPipeline(undefined);
        goHome();
      }
      setPipelinesToDelete([]);
    },
    pipelinesToDelete: pipelinesToDelete
  }) : null);
};
exports.PipelinesList = PipelinesList;