"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PipelinesClone = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _shared_imports = require("../../../shared_imports");
var _pipelines_create = require("../pipelines_create");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * This section is a wrapper around the create section where we receive a pipeline name
 * to load and set as the source pipeline for the {@link PipelinesCreate} form.
 */
const PipelinesClone = props => {
  const {
    sourceName
  } = props.match.params;
  const {
    services
  } = (0, _shared_imports.useKibana)();
  const decodedSourceName = (0, _shared_imports.attemptToURIDecode)(sourceName);
  const {
    error,
    data: pipeline,
    isLoading,
    isInitialRequest
  } = services.api.useLoadPipeline(decodedSourceName);
  (0, _react.useEffect)(() => {
    if (error && !isLoading) {
      services.notifications.toasts.addError(error, {
        title: _i18n.i18n.translate('xpack.ingestPipelines.clone.loadSourcePipelineErrorTitle', {
          defaultMessage: 'Cannot load {name}.',
          values: {
            name: sourceName
          }
        })
      });
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [error, isLoading]);
  if (isLoading && isInitialRequest) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPageContent_Deprecated, {
      verticalPosition: "center",
      horizontalPosition: "center",
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement(_shared_imports.SectionLoading, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.clone.loadingPipelinesDescription",
      defaultMessage: "Loading pipeline\u2026"
    })));
  } else {
    // We still show the create form even if we were not able to load the
    // latest pipeline data.
    const sourcePipeline = pipeline ? {
      ...pipeline,
      name: `${pipeline.name}-copy`
    } : undefined;
    return /*#__PURE__*/_react.default.createElement(_pipelines_create.PipelinesCreate, (0, _extends2.default)({}, props, {
      sourcePipeline: sourcePipeline
    }));
  }
};
exports.PipelinesClone = PipelinesClone;