"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.stringifyJson = exports.parseJson = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const stringifyJson = (json, renderAsArray = true) => renderAsArray && Array.isArray(json) || !renderAsArray && json && typeof json === 'object' && !Array.isArray(json) ? JSON.stringify(json, null, 2) : renderAsArray ? '[\n\n]' : '{\n\n}';
exports.stringifyJson = stringifyJson;
const parseJson = (jsonString, renderAsArray = true) => {
  let parsedJSON;
  try {
    parsedJSON = JSON.parse(jsonString);
    if (renderAsArray && !Array.isArray(parsedJSON)) {
      // Convert object to array
      parsedJSON = [parsedJSON];
    }
  } catch {
    parsedJSON = renderAsArray ? [] : {};
  }
  return parsedJSON;
};
exports.parseJson = parseJson;