"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OutputTab = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OutputTab = ({
  handleTestPipeline,
  isRunningTest,
  cachedVerbose,
  cachedDocuments,
  testOutput
}) => {
  const [isVerboseEnabled, setIsVerboseEnabled] = (0, _react.useState)(Boolean(cachedVerbose));
  let content;
  if (isRunningTest) {
    content = /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "m"
    });
  } else if (testOutput) {
    content = /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      language: "json",
      isCopyable: true
    }, JSON.stringify(testOutput, null, 2));
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "outputTabContent"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ingestPipelines.testPipelineFlyout.outputTab.descriptionText",
    defaultMessage: "View the output data, or see how each processor affects the document as it passes through the pipeline."
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.testPipelineFlyout.outputTab.verboseSwitchLabel",
      defaultMessage: "View verbose output"
    }),
    checked: isVerboseEnabled,
    "data-test-subj": "verboseOutputToggle",
    onChange: async e => {
      const isVerbose = e.target.checked;
      setIsVerboseEnabled(isVerbose);
      await handleTestPipeline({
        documents: cachedDocuments,
        verbose: isVerbose
      });
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    size: "s",
    onClick: async () => await handleTestPipeline({
      documents: cachedDocuments,
      verbose: isVerboseEnabled
    }, true),
    iconType: "refresh",
    "data-test-subj": "refreshOutputButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ingestPipelines.testPipelineFlyout.outputTab.descriptionLinkLabel",
    defaultMessage: "Refresh output"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), content);
};
exports.OutputTab = OutputTab;