"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrivateTree = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactVirtualized = require("react-virtualized");
var _constants = require("../../../constants");
var _processors_reducer = require("../../../processors_reducer");
var _utils = require("../../../utils");
var _2 = require(".");
var _utils2 = require("../utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isDropZoneAboveDisabled = (processor, selectedProcessor) => {
  return Boolean(
  // Is the selected node first in a list?
  !selectedProcessor.aboveId && selectedProcessor.id === processor.id || (0, _processors_reducer.isChildPath)(selectedProcessor.selector, processor.selector));
};
const isDropZoneBelowDisabled = (processor, selectedProcessor) => {
  return processor.id === selectedProcessor.id || processor.belowId === selectedProcessor.id || (0, _processors_reducer.isChildPath)(selectedProcessor.selector, processor.selector);
};

/**
 * Recursively rendering tree component for ingest pipeline processors.
 *
 * Note: this tree should start at level 1. It is the only level at
 * which we render the optimised virtual component. This gives a
 * massive performance boost to this component which can get very tall.
 *
 * The first level list also contains the outside click listener which
 * enables users to click outside of the tree and cancel moving a
 * processor.
 */
const PrivateTree = ({
  processors,
  selector,
  movingProcessor,
  onAction,
  level,
  windowScrollerRef,
  listRef
}) => {
  const selectors = (0, _react.useMemo)(() => {
    return processors.map((_, idx) => selector.concat(String(idx)));
  }, [processors, selector]);
  const renderRow = ({
    idx,
    info,
    processor
  }) => {
    const stringifiedSelector = (0, _utils.selectorToDataTestSubject)(info.selector);
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, idx === 0 ? /*#__PURE__*/_react.default.createElement(_2.DropZoneButton, {
      "data-test-subj": `dropButtonAbove-${stringifiedSelector}`,
      onClick: event => {
        event.preventDefault();
        onAction({
          type: 'move',
          payload: {
            destination: selector.concat(_constants.DropSpecialLocations.top),
            source: movingProcessor.selector
          }
        });
      },
      isVisible: Boolean(movingProcessor),
      isDisabled: !movingProcessor || isDropZoneAboveDisabled(info, movingProcessor)
    }) : undefined, /*#__PURE__*/_react.default.createElement(_2.TreeNode, {
      level: level,
      processor: processor,
      processorInfo: info,
      onAction: onAction,
      movingProcessor: movingProcessor
    }), /*#__PURE__*/_react.default.createElement(_2.DropZoneButton, {
      compressed: level === 1 && idx + 1 === processors.length,
      "data-test-subj": `dropButtonBelow-${stringifiedSelector}`,
      isVisible: Boolean(movingProcessor),
      isDisabled: !movingProcessor || isDropZoneBelowDisabled(info, movingProcessor),
      onClick: event => {
        event.preventDefault();
        onAction({
          type: 'move',
          payload: {
            destination: selector.concat(String(idx + 1)),
            source: movingProcessor.selector
          }
        });
      }
    }));
  };
  (0, _react.useEffect)(() => {
    if (windowScrollerRef && windowScrollerRef.current) {
      windowScrollerRef.current.updatePosition();
    }
    if (listRef && listRef.current) {
      listRef.current.recomputeRowHeights();
    }
  }, [processors, listRef, windowScrollerRef, movingProcessor]);

  // A list optimized to handle very many items.
  const renderVirtualList = () => {
    return /*#__PURE__*/_react.default.createElement(_reactVirtualized.WindowScroller, {
      ref: windowScrollerRef,
      scrollElement: window
    }, ({
      height,
      registerChild,
      isScrolling,
      onChildScroll,
      scrollTop
    }) => {
      return /*#__PURE__*/_react.default.createElement(_reactVirtualized.AutoSizer, {
        disableHeight: true
      }, ({
        width
      }) => {
        return /*#__PURE__*/_react.default.createElement("div", {
          style: {
            width: '100%'
          },
          ref: registerChild
        }, /*#__PURE__*/_react.default.createElement(_reactVirtualized.List, {
          ref: listRef,
          autoHeight: true,
          height: height,
          width: width,
          overScanRowCount: 5,
          isScrolling: isScrolling,
          onChildScroll: onChildScroll,
          scrollTop: scrollTop,
          rowCount: processors.length,
          rowHeight: ({
            index
          }) => {
            const processor = processors[index];
            return (0, _utils2.calculateItemHeight)({
              processor,
              isFirstInArray: index === 0
            });
          },
          rowRenderer: ({
            index: idx,
            style
          }) => {
            const processor = processors[idx];
            const above = processors[idx - 1];
            const below = processors[idx + 1];
            const info = {
              id: processor.id,
              selector: selectors[idx],
              aboveId: above === null || above === void 0 ? void 0 : above.id,
              belowId: below === null || below === void 0 ? void 0 : below.id
            };
            return /*#__PURE__*/_react.default.createElement("div", {
              style: style,
              key: processor.id
            }, renderRow({
              processor,
              info,
              idx
            }));
          },
          processors: processors
        }));
      });
    });
  };
  if (level === 1) {
    // Only render the optimised list for the top level list because that is the list
    // that will almost certainly be the tallest
    return renderVirtualList();
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    responsive: false,
    gutterSize: "none"
  }, processors.map((processor, idx) => {
    const above = processors[idx - 1];
    const below = processors[idx + 1];
    const info = {
      id: processor.id,
      selector: selector.concat(String(idx)),
      aboveId: above === null || above === void 0 ? void 0 : above.id,
      belowId: below === null || below === void 0 ? void 0 : below.id
    };
    return /*#__PURE__*/_react.default.createElement("div", {
      key: processor.id
    }, renderRow({
      processor,
      idx,
      info
    }));
  }));
};
exports.PrivateTree = PrivateTree;