"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Json = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _shared_imports = require("../../../../../../shared_imports");
var _shared = require("./shared");
var _field_name_field = require("./common_fields/field_name_field");
var _target_field = require("./common_fields/target_field");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ADD_TO_ROOT_FIELD_PATH = 'fields.add_to_root';
const fieldsConfig = {
  /* Optional fields config */
  add_to_root: {
    type: _shared_imports.FIELD_TYPES.TOGGLE,
    defaultValue: false,
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.jsonForm.addToRootFieldLabel', {
      defaultMessage: 'Add to root'
    }),
    deserializer: _shared.to.booleanOrUndef,
    serializer: _shared.from.undefinedIfValue(false),
    helpText: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.jsonForm.addToRootFieldHelpText', {
      defaultMessage: 'Add the JSON object to the top level of the document. Cannot be combined with a target field.'
    })
  }
};
const Json = () => {
  const form = (0, _shared_imports.useFormContext)();
  const [isAddToPathDisabled, setIsAddToPathDisabled] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    const subscription = form.subscribe(({
      data: {
        internal
      }
    }) => {
      const hasTargetField = !!(0, _lodash.get)(internal, _target_field.TARGET_FIELD_PATH);
      if (hasTargetField && !isAddToPathDisabled) {
        setIsAddToPathDisabled(true);
        form.getFields()[ADD_TO_ROOT_FIELD_PATH].setValue(false);
      } else if (!hasTargetField && isAddToPathDisabled) {
        setIsAddToPathDisabled(false);
      }
    });
    return subscription.unsubscribe;
  }, [form, isAddToPathDisabled]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_field_name_field.FieldNameField, {
    helpText: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.jsonForm.fieldNameHelpText', {
      defaultMessage: 'Field to parse.'
    })
  }), /*#__PURE__*/_react.default.createElement(_target_field.TargetField, null), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    config: fieldsConfig.add_to_root,
    component: _shared_imports.ToggleField,
    componentProps: {
      euiFieldProps: {
        disabled: isAddToPathDisabled
      }
    },
    path: ADD_TO_ROOT_FIELD_PATH
  }));
};
exports.Json = Json;