"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Grok = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _shared_imports = require("../../../../../../shared_imports");
var _field_components = require("../field_components");
var _field_name_field = require("./common_fields/field_name_field");
var _ignore_missing_field = require("./common_fields/ignore_missing_field");
var _shared = require("./shared");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  isJsonField,
  emptyField
} = _shared_imports.fieldValidators;
const i18nTexts = {
  addPatternLabel: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.grokForm.patternsAddPatternLabel', {
    defaultMessage: 'Add pattern'
  })
};
const valueRequiredMessage = _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.grokForm.patternsValueRequiredError', {
  defaultMessage: 'A value is required.'
});
const patternsValidation = ({
  value,
  formData
}) => {
  if (value.length === 0) {
    return {
      message: valueRequiredMessage
    };
  }
};
const patternValidations = [emptyField(valueRequiredMessage)];
const fieldsConfig = {
  /* Required field configs */
  patterns: {
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.grokForm.patternsFieldLabel', {
      defaultMessage: 'Patterns'
    }),
    deserializer: String,
    helpText: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.grokForm.patternsHelpText', {
      defaultMessage: 'Grok expressions used to match and extract named capture groups. Uses the first matching expression.'
    }),
    validations: [{
      validator: patternsValidation
    }]
  },
  /* Optional field configs */
  pattern_definitions: {
    type: _shared_imports.FIELD_TYPES.TEXT,
    deserializer: _shared.to.jsonString,
    serializer: _shared.from.optionalJson,
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.grokForm.patternDefinitionsLabel', {
      defaultMessage: 'Pattern definitions (optional)'
    }),
    helpText: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.grokForm.patternDefinitionsHelpText', {
      defaultMessage: 'A map of pattern-name and pattern tuples defining custom patterns. Patterns matching existing names will override the pre-existing definition.'
    }),
    validations: [{
      validator: isJsonField(_i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.grokForm.patternsDefinitionsInvalidJSONError', {
        defaultMessage: 'Invalid JSON'
      }), {
        allowEmptyString: true
      })
    }]
  },
  trace_match: {
    type: _shared_imports.FIELD_TYPES.TOGGLE,
    defaultValue: false,
    deserializer: _shared.to.booleanOrUndef,
    serializer: _shared.from.undefinedIfValue(false),
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.grokForm.traceMatchFieldLabel', {
      defaultMessage: 'Trace match'
    }),
    helpText: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.grokForm.traceMatchFieldHelpText', {
      defaultMessage: 'Add metadata about the matching expression to the document.'
    })
  }
};
const Grok = () => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_field_name_field.FieldNameField, {
    helpText: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.grokForm.fieldNameHelpText', {
      defaultMessage: 'Field to search for matches.'
    })
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseArray, {
    path: "fields.patterns",
    validations: fieldsConfig.patterns.validations
  }, ({
    items,
    addItem,
    removeItem,
    moveItem,
    error
  }) => {
    var _fieldsConfig$pattern, _fieldsConfig$pattern2;
    return /*#__PURE__*/_react.default.createElement(_field_components.DragAndDropTextList, {
      label: fieldsConfig.patterns.label,
      helpText: fieldsConfig.patterns.helpText,
      error: error,
      value: items,
      onMove: moveItem,
      onAdd: addItem,
      onRemove: removeItem,
      addLabel: i18nTexts.addPatternLabel,
      textValidations: patternValidations,
      textDeserializer: (_fieldsConfig$pattern = fieldsConfig.patterns) === null || _fieldsConfig$pattern === void 0 ? void 0 : _fieldsConfig$pattern.deserializer,
      textSerializer: (_fieldsConfig$pattern2 = fieldsConfig.patterns) === null || _fieldsConfig$pattern2 === void 0 ? void 0 : _fieldsConfig$pattern2.serializer
    });
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    component: _field_components.XJsonEditor,
    config: fieldsConfig.pattern_definitions,
    componentProps: {
      editorProps: {
        height: _shared.EDITOR_PX_HEIGHT.medium,
        'aria-label': _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.grokForm.patternDefinitionsAriaLabel', {
          defaultMessage: 'Pattern definitions editor'
        })
      }
    },
    path: "fields.pattern_definitions"
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    component: _shared_imports.ToggleField,
    config: fieldsConfig.trace_match,
    path: "fields.trace_match"
  }), /*#__PURE__*/_react.default.createElement(_ignore_missing_field.IgnoreMissingField, null));
};
exports.Grok = Grok;