"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DragAndDropTextList = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _uuid = require("uuid");
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../../../../shared_imports");
require("./drag_and_drop_text_list.scss");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const i18nTexts = {
  removeItemButtonAriaLabel: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.dragAndDropList.removeItemLabel', {
    defaultMessage: 'Remove item'
  })
};
function DragAndDropTextListComponent({
  label,
  helpText,
  error,
  value,
  onMove,
  onAdd,
  onRemove,
  addLabel,
  textValidations,
  textDeserializer,
  textSerializer
}) {
  const [droppableId] = (0, _react.useState)(() => (0, _uuid.v4)());
  const [firstItemId] = (0, _react.useState)(() => (0, _uuid.v4)());
  const onDragEnd = (0, _react.useCallback)(({
    source,
    destination
  }) => {
    if (source && destination) {
      onMove(source.index, destination.index);
    }
  }, [onMove]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    isInvalid: typeof error === 'string',
    error: error,
    fullWidth: true,
    "data-test-subj": "droppableList"
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    className: "pipelineProcessorsEditor__form__dragAndDropList__labelContainer",
    justifyContent: "flexStart",
    direction: "column",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("label", {
    htmlFor: firstItemId
  }, /*#__PURE__*/_react.default.createElement("strong", null, label)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", null, helpText)))), /*#__PURE__*/_react.default.createElement("div", {
    className: "pipelineProcessorsEditor__form__dragAndDropList__panel"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDragDropContext, {
    onDragEnd: onDragEnd
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDroppable, {
    droppableId: droppableId
  }, value.map((item, idx) => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiDraggable, {
      customDragHandle: true,
      spacing: "none",
      draggableId: String(item.id),
      index: idx,
      key: item.id
    }, provided => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        className: "pipelineProcessorsEditor__form__dragAndDropList__item",
        justifyContent: "center",
        gutterSize: "none"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({}, provided.dragHandleProps, {
        className: "pipelineProcessorsEditor__form__dragAndDropList__grabIcon"
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "grab"
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
        path: item.path,
        config: {
          validations: textValidations ? textValidations.map(validator => ({
            validator
          })) : undefined,
          deserializer: textDeserializer,
          serializer: textSerializer
        },
        readDefaultValueOnForm: !item.isNew
      }, field => {
        const {
          isInvalid,
          errorMessage
        } = (0, _shared_imports.getFieldValidityAndErrorMessage)(field);
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
          isInvalid: isInvalid,
          error: errorMessage,
          fullWidth: true
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
          "data-test-subj": `input-${idx}`,
          id: idx === 0 ? firstItemId : undefined,
          isInvalid: isInvalid,
          value: field.value,
          onChange: field.onChange,
          compressed: true,
          fullWidth: true
        }));
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, value.length > 1 ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        "aria-label": i18nTexts.removeItemButtonAriaLabel,
        className: "pipelineProcessorsEditor__form__dragAndDropList__removeButton",
        iconType: "minusInCircle",
        color: "danger",
        onClick: () => onRemove(item.id),
        size: "s"
      }) :
      /*#__PURE__*/
      // Render a no-op placeholder button
      _react.default.createElement(_eui.EuiIcon, {
        className: "pipelineProcessorsEditor__form__dragAndDropList__removeButton",
        type: "empty"
      })));
    });
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "plusInCircle",
    onClick: onAdd,
    "data-test-subj": "addButton"
  }, addLabel))));
}
const DragAndDropTextList = /*#__PURE__*/(0, _react.memo)(DragAndDropTextListComponent);
exports.DragAndDropTextList = DragAndDropTextList;