"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InlineTextInput = void 0;
var _classnames = _interopRequireDefault(require("classnames"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function _InlineTextInput({
  placeholder,
  text,
  ariaLabel,
  disabled = false,
  onChange
}) {
  const [isShowingTextInput, setIsShowingTextInput] = (0, _react.useState)(false);
  const [textValue, setTextValue] = (0, _react.useState)(() => text !== null && text !== void 0 ? text : '');
  const containerClasses = (0, _classnames.default)('pipelineProcessorsEditor__item__textContainer', {
    'pipelineProcessorsEditor__item__textContainer--notEditing': !isShowingTextInput && !disabled
  });
  const submitChange = (0, _react.useCallback)(() => {
    // Give any on blur handlers the chance to complete if the user is
    // tabbing over this component.
    setTimeout(() => {
      setIsShowingTextInput(false);
      onChange(textValue);
    });
  }, [setIsShowingTextInput, onChange, textValue]);
  (0, _react.useEffect)(() => {
    setTextValue(text !== null && text !== void 0 ? text : '');
  }, [text]);
  (0, _react.useEffect)(() => {
    const keyboardListener = event => {
      if (event.key === _eui.keys.ESCAPE || event.code === 'Escape') {
        setIsShowingTextInput(false);
      }
      if (event.key === _eui.keys.ENTER || event.code === 'Enter') {
        submitChange();
      }
    };
    if (isShowingTextInput) {
      window.addEventListener('keyup', keyboardListener);
    }
    return () => {
      window.removeEventListener('keyup', keyboardListener);
    };
  }, [isShowingTextInput, submitChange, setIsShowingTextInput]);
  return isShowingTextInput && !disabled ? /*#__PURE__*/_react.default.createElement("div", {
    className: `pipelineProcessorsEditor__item__textContainer ${containerClasses}`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    controlOnly: true,
    onBlur: submitChange,
    fullWidth: true,
    compressed: true,
    value: textValue,
    "aria-label": ariaLabel,
    className: "pipelineProcessorsEditor__item__textInput",
    inputRef: el => el === null || el === void 0 ? void 0 : el.focus(),
    onChange: event => setTextValue(event.target.value)
  })) : /*#__PURE__*/_react.default.createElement("div", {
    className: containerClasses,
    tabIndex: disabled ? -1 : 0,
    onFocus: () => setIsShowingTextInput(true)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: text !== null && text !== void 0 ? text : placeholder
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "pipelineProcessorsEditor__item__description",
    "data-test-subj": "inlineTextInputNonEditableText"
  }, text || /*#__PURE__*/_react.default.createElement("em", null, placeholder)))));
}
const InlineTextInput = /*#__PURE__*/(0, _react.memo)(_InlineTextInput);
exports.InlineTextInput = InlineTextInput;