"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.i18nTexts = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const i18nTexts = {
  moveButtonLabel: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.item.moveButtonLabel', {
    defaultMessage: 'Move this processor'
  }),
  editButtonLabel: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.item.editButtonAriaLabel', {
    defaultMessage: 'Edit this processor'
  }),
  duplicateButtonLabel: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.item.moreMenu.duplicateButtonLabel', {
    defaultMessage: 'Duplicate this processor'
  }),
  addOnFailureButtonLabel: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.item.moreMenu.addOnFailureHandlerButtonLabel', {
    defaultMessage: 'Add on failure handler'
  }),
  cancelMoveButtonLabel: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.item.cancelMoveButtonAriaLabel', {
    defaultMessage: 'Cancel move'
  }),
  deleteButtonLabel: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.item.moreMenu.deleteButtonLabel', {
    defaultMessage: 'Delete'
  }),
  moreButtonAriaLabel: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.item.moreButtonAriaLabel', {
    defaultMessage: 'Show more actions for this processor'
  }),
  processorTypeLabel: ({
    type
  }) => _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.item.textInputAriaLabel', {
    defaultMessage: 'Provide a description for this {type} processor',
    values: {
      type
    }
  }),
  descriptionPlaceholder: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.item.descriptionPlaceholder', {
    defaultMessage: 'No description'
  })
};
exports.i18nTexts = i18nTexts;