/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements.
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */
(window.infra_bundle_jsonpfunction=window.infra_bundle_jsonpfunction||[]).push([[2],{102:function(e,i,t){"use strict";Object.defineProperty(i,"__esModule",{value:!0});var s=t(59).__importDefault(t(129));i.default=function(e){s.default((function(){e()}))}},129:function(e,i,t){"use strict";Object.defineProperty(i,"__esModule",{value:!0});var s=t(2);i.default=function(e){s.useEffect(e,[])}},199:function(e,i,t){"use strict";t.d(i,"a",(function(){return r})),t.d(i,"b",(function(){return d}));const s={cpu:{cpu_user:{avg:{field:"system.cpu.user.pct"}},cpu_system:{avg:{field:"system.cpu.system.pct"}},cpu_cores:{max:{field:"system.cpu.cores"}},cpu:{bucket_script:{buckets_path:{user:"cpu_user",system:"cpu_system",cores:"cpu_cores"},script:{source:"(params.user + params.system) / params.cores",lang:"painless"},gap_policy:"skip"}}},diskLatency:{diskio_read_time:{avg:{field:"system.diskio.read.time"}},diskio_write_time:{avg:{field:"system.diskio.write.time"}},diskio_read_count:{avg:{field:"system.diskio.read.count"}},diskio_write_count:{avg:{field:"system.diskio.write.count"}},diskLatency:{bucket_script:{buckets_path:{read_time:"diskio_read_time",write_time:"diskio_write_time",read_count:"diskio_read_count",write_count:"diskio_write_count"},script:{source:"(params.write_time + params.read_time) / (params.read_count + params.write_count)",lang:"painless"},gap_policy:"skip"}}},load:{load:{avg:{field:"system.load.5"}}},logRate:{count:{bucket_script:{buckets_path:{count:"_count"},script:{source:"count * 1",lang:"expression"},gap_policy:"skip"}},cumsum:{cumulative_sum:{buckets_path:"count"}},logRate:{derivative:{buckets_path:"cumsum",gap_policy:"skip",unit:"1s"}}},memory:{memory:{avg:{field:"system.memory.actual.used.pct"}}},memoryTotal:{memory_total:{avg:{field:"system.memory.total"}},memoryTotal:{bucket_script:{buckets_path:{memoryTotal:"memory_total"},script:{source:"params.memoryTotal",lang:"painless"},gap_policy:"skip"}}},rx:{rx_avg:{avg:{field:"host.network.ingress.bytes"}},rx_period:{filter:{exists:{field:"host.network.ingress.bytes"}},aggs:{period:{max:{field:"metricset.period"}}}},rx:{bucket_script:{buckets_path:{value:"rx_avg",period:"rx_period>period"},script:{source:"params.value / (params.period / 1000)",lang:"painless"},gap_policy:"skip"}}},tx:{tx_avg:{avg:{field:"host.network.egress.bytes"}},tx_period:{filter:{exists:{field:"host.network.egress.bytes"}},aggs:{period:{max:{field:"metricset.period"}}}},tx:{bucket_script:{buckets_path:{value:"tx_avg",period:"tx_period>period"},script:{source:"params.value / (params.period / 1000)",lang:"painless"},gap_policy:"skip"}}}},a={count:t(275).a,...s},r=Object.keys(s),d={tsvb:{hostSystemOverview:(e,i,t)=>({id:"hostSystemOverview",requires:["system.cpu","system.memory","system.load","system.network"],index_pattern:i,interval:t,time_field:e,type:"top_n",series:[{id:"cpu",split_mode:"everything",metrics:[{field:"system.cpu.total.norm.pct",id:"avg-cpu-total",type:"avg"}]},{id:"load",split_mode:"everything",metrics:[{field:"system.load.5",id:"avg-load-5m",type:"avg"}]},{id:"memory",split_mode:"everything",metrics:[{field:"system.memory.actual.used.pct",id:"avg-memory-actual-used",type:"avg"}]},{id:"rx",metrics:[{field:"host.network.ingress.bytes",id:"avg-net-in",type:"avg"},{id:"max-period",type:"max",field:"metricset.period"},{id:"3216b170-f192-11ec-a8e3-dd984b7213e2",type:"calculation",variables:[{id:"34e64c30-f192-11ec-a8e3-dd984b7213e2",name:"value",field:"avg-net-in"},{id:"3886cb80-f192-11ec-a8e3-dd984b7213e2",name:"period",field:"max-period"}],script:"params.value / (params.period / 1000)"}],filter:{language:"kuery",query:"host.network.ingress.bytes : * "},split_mode:"everything"},{id:"tx",metrics:[{field:"host.network.egress.bytes",id:"avg-net-out",type:"avg"},{id:"max-period",type:"max",field:"metricset.period"},{id:"3216b170-f192-11ec-a8e3-dd984b7213e2",type:"calculation",variables:[{id:"34e64c30-f192-11ec-a8e3-dd984b7213e2",name:"value",field:"avg-net-out"},{id:"3886cb80-f192-11ec-a8e3-dd984b7213e2",name:"period",field:"max-period"}],script:"params.value / (params.period / 1000)"}],filter:{language:"kuery",query:"host.network.egress.bytes : * "},split_mode:"everything"}]}),hostCpuUsage:(e,i,t)=>({id:"hostCpuUsage",requires:["system.cpu"],index_pattern:i,interval:t,time_field:e,type:"timeseries",series:[{id:"user",metrics:[{field:"system.cpu.user.pct",id:"avg-cpu-user",type:"avg"},{field:"system.cpu.cores",id:"max-cpu-cores",type:"max"},{id:"calc-avg-cores",script:"params.avg / params.cores",type:"calculation",variables:[{field:"max-cpu-cores",id:"var-cores",name:"cores"},{field:"avg-cpu-user",id:"var-avg",name:"avg"}]}],split_mode:"everything"},{id:"system",metrics:[{field:"system.cpu.system.pct",id:"avg-cpu-system",type:"avg"},{field:"system.cpu.cores",id:"max-cpu-cores",type:"max"},{id:"calc-avg-cores",script:"params.avg / params.cores",type:"calculation",variables:[{field:"max-cpu-cores",id:"var-cores",name:"cores"},{field:"avg-cpu-system",id:"var-avg",name:"avg"}]}],split_mode:"everything"},{id:"steal",metrics:[{field:"system.cpu.steal.pct",id:"avg-cpu-steal",type:"avg"},{field:"system.cpu.cores",id:"max-cpu-cores",type:"max"},{id:"calc-avg-cores",script:"params.avg / params.cores",type:"calculation",variables:[{field:"avg-cpu-steal",id:"var-avg",name:"avg"},{field:"max-cpu-cores",id:"var-cores",name:"cores"}]}],split_mode:"everything"},{id:"irq",metrics:[{field:"system.cpu.irq.pct",id:"avg-cpu-irq",type:"avg"},{field:"system.cpu.cores",id:"max-cpu-cores",type:"max"},{id:"calc-avg-cores",script:"params.avg / params.cores",type:"calculation",variables:[{field:"max-cpu-cores",id:"var-cores",name:"cores"},{field:"avg-cpu-irq",id:"var-avg",name:"avg"}]}],split_mode:"everything"},{id:"softirq",metrics:[{field:"system.cpu.softirq.pct",id:"avg-cpu-softirq",type:"avg"},{field:"system.cpu.cores",id:"max-cpu-cores",type:"max"},{id:"calc-avg-cores",script:"params.avg / params.cores",type:"calculation",variables:[{field:"max-cpu-cores",id:"var-cores",name:"cores"},{field:"avg-cpu-softirq",id:"var-avg",name:"avg"}]}],split_mode:"everything"},{id:"iowait",metrics:[{field:"system.cpu.iowait.pct",id:"avg-cpu-iowait",type:"avg"},{field:"system.cpu.cores",id:"max-cpu-cores",type:"max"},{id:"calc-avg-cores",script:"params.avg / params.cores",type:"calculation",variables:[{field:"max-cpu-cores",id:"var-cores",name:"cores"},{field:"avg-cpu-iowait",id:"var-avg",name:"avg"}]}],split_mode:"everything"},{id:"nice",metrics:[{field:"system.cpu.nice.pct",id:"avg-cpu-nice",type:"avg"},{field:"system.cpu.cores",id:"max-cpu-cores",type:"max"},{id:"calc-avg-cores",script:"params.avg / params.cores",type:"calculation",variables:[{field:"max-cpu-cores",id:"var-cores",name:"cores"},{field:"avg-cpu-nice",id:"var-avg",name:"avg"}]}],split_mode:"everything"}]}),hostLoad:(e,i,t)=>({id:"hostLoad",requires:["system.cpu"],index_pattern:i,interval:t,time_field:e,type:"timeseries",series:[{id:"load_1m",metrics:[{field:"system.load.1",id:"avg-load-1m",type:"avg"}],split_mode:"everything"},{id:"load_5m",metrics:[{field:"system.load.5",id:"avg-load-5m",type:"avg"}],split_mode:"everything"},{id:"load_15m",metrics:[{field:"system.load.15",id:"avg-load-15m",type:"avg"}],split_mode:"everything"}]}),hostMemoryUsage:(e,i,t)=>({id:"hostMemoryUsage",requires:["system.memory"],index_pattern:i,interval:t,time_field:e,type:"timeseries",series:[{id:"free",metrics:[{field:"system.memory.free",id:"avg-memory-free",type:"avg"}],split_mode:"everything"},{id:"used",metrics:[{field:"system.memory.actual.used.bytes",id:"avg-memory-used",type:"avg"}],split_mode:"everything"},{id:"cache",metrics:[{field:"system.memory.actual.used.bytes",id:"avg-memory-actual-used",type:"avg"},{field:"system.memory.used.bytes",id:"avg-memory-used",type:"avg"},{id:"calc-used-actual",script:"params.used - params.actual",type:"calculation",variables:[{field:"avg-memory-actual-used",id:"var-actual",name:"actual"},{field:"avg-memory-used",id:"var-used",name:"used"}]}],split_mode:"everything"}]}),hostNetworkTraffic:(e,i,t)=>({id:"hostNetworkTraffic",requires:["system.network"],index_pattern:i,interval:t,time_field:e,type:"timeseries",series:[{id:"tx",metrics:[{field:"host.network.egress.bytes",id:"avg-net-out",type:"avg"},{id:"max-period",type:"max",field:"metricset.period"},{id:"3216b170-f192-11ec-a8e3-dd984b7213e2",type:"calculation",variables:[{id:"34e64c30-f192-11ec-a8e3-dd984b7213e2",name:"value",field:"avg-net-out"},{id:"3886cb80-f192-11ec-a8e3-dd984b7213e2",name:"period",field:"max-period"}],script:"params.value / (params.period / 1000)"}],filter:{language:"kuery",query:"host.network.egress.bytes : * "},split_mode:"everything"},{id:"rx",metrics:[{field:"host.network.ingress.bytes",id:"avg-net-in",type:"avg"},{id:"calc-invert-rate",script:"params.rate * -1",type:"calculation",variables:[{field:"avg-net-in",id:"var-rate",name:"rate"}]},{id:"max-period",type:"max",field:"metricset.period"},{id:"3216b170-f192-11ec-a8e3-dd984b7213e2",type:"calculation",variables:[{id:"34e64c30-f192-11ec-a8e3-dd984b7213e2",name:"value",field:"calc-invert-rate"},{id:"3886cb80-f192-11ec-a8e3-dd984b7213e2",name:"period",field:"max-period"}],script:"params.value / (params.period / 1000)"}],filter:{language:"kuery",query:"host.network.ingress.bytes : * "},split_mode:"everything"}]}),hostFilesystem:(e,i,t)=>({id:"hostFilesystem",requires:["system.filesystem"],filter:"system.filesystem.device_name:\\/*",index_pattern:i,time_field:e,interval:t,type:"timeseries",series:[{id:"used",metrics:[{field:"system.filesystem.used.pct",id:"avg-filesystem-used",type:"avg"}],split_mode:"terms",terms_field:"system.filesystem.device_name",terms_order_by:"used",terms_size:5}]}),hostK8sOverview:(e,i,t)=>({id:"hostK8sOverview",requires:["kubernetes"],index_pattern:i,interval:t,time_field:e,type:"top_n",series:[{id:"cpucap",split_mode:"everything",metrics:[{field:"kubernetes.node.cpu.allocatable.cores",id:"max-cpu-cap",type:"max"},{field:"kubernetes.node.cpu.usage.nanocores",id:"avg-cpu-usage",type:"avg"},{id:"calc-used-cap",script:"params.used / (params.cap * 1000000000)",type:"calculation",variables:[{field:"max-cpu-cap",id:"var-cap",name:"cap"},{field:"avg-cpu-usage",id:"var-used",name:"used"}]}]},{id:"diskcap",metrics:[{field:"kubernetes.node.fs.capacity.bytes",id:"max-fs-cap",type:"max"},{field:"kubernetes.node.fs.used.bytes",id:"avg-fs-used",type:"avg"},{id:"calc-used-cap",script:"params.used / params.cap",type:"calculation",variables:[{field:"max-fs-cap",id:"var-cap",name:"cap"},{field:"avg-fs-used",id:"var-used",name:"used"}]}],split_mode:"everything"},{id:"memorycap",metrics:[{field:"kubernetes.node.memory.allocatable.bytes",id:"max-memory-cap",type:"max"},{field:"kubernetes.node.memory.usage.bytes",id:"avg-memory-usage",type:"avg"},{id:"calc-used-cap",script:"params.used / params.cap",type:"calculation",variables:[{field:"max-memory-cap",id:"var-cap",name:"cap"},{field:"avg-memory-usage",id:"var-used",name:"used"}]}],split_mode:"everything"},{id:"podcap",metrics:[{field:"kubernetes.node.pod.capacity.total",id:"max-pod-cap",type:"max"},{field:"kubernetes.pod.uid",id:"card-pod-name",type:"cardinality"},{id:"calc-used-cap",script:"params.used / params.cap",type:"calculation",variables:[{field:"max-pod-cap",id:"var-cap",name:"cap"},{field:"card-pod-name",id:"var-used",name:"used"}]}],split_mode:"everything"}]}),hostK8sCpuCap:(e,i,t)=>({id:"hostK8sCpuCap",map_field_to:"kubernetes.node.name",requires:["kubernetes.node"],index_pattern:i,interval:t,time_field:e,type:"timeseries",series:[{id:"capacity",metrics:[{field:"kubernetes.node.cpu.allocatable.cores",id:"max-cpu-cap",type:"max"},{id:"calc-nanocores",type:"calculation",variables:[{id:"var-cores",field:"max-cpu-cap",name:"cores"}],script:"params.cores * 1000000000"}],split_mode:"everything"},{id:"used",metrics:[{field:"kubernetes.node.cpu.usage.nanocores",id:"avg-cpu-usage",type:"avg"}],split_mode:"everything"}]}),hostK8sPodCap:(e,i,t)=>({id:"hostK8sPodCap",requires:["kubernetes.node"],map_field_to:"kubernetes.node.name",index_pattern:i,interval:t,time_field:e,type:"timeseries",series:[{id:"capacity",metrics:[{field:"kubernetes.node.pod.allocatable.total",id:"max-pod-cap",type:"max"}],split_mode:"everything"},{id:"used",metrics:[{field:"kubernetes.pod.uid",id:"avg-pod",type:"cardinality"}],split_mode:"everything"}]}),hostK8sDiskCap:(e,i,t)=>({id:"hostK8sDiskCap",map_field_to:"kubernetes.node.name",requires:["kubernetes.node"],index_pattern:i,interval:t,time_field:e,type:"timeseries",series:[{id:"capacity",metrics:[{field:"kubernetes.node.fs.capacity.bytes",id:"max-fs-cap",type:"max"}],split_mode:"everything"},{id:"used",metrics:[{field:"kubernetes.node.fs.used.bytes",id:"avg-fs-used",type:"avg"}],split_mode:"everything"}]}),hostK8sMemoryCap:(e,i,t)=>({id:"hostK8sMemoryCap",map_field_to:"kubernetes.node.name",requires:["kubernetes.node"],index_pattern:i,interval:t,time_field:e,type:"timeseries",series:[{id:"capacity",metrics:[{field:"kubernetes.node.memory.allocatable.bytes",id:"max-memory-cap",type:"max"}],split_mode:"everything"},{id:"used",metrics:[{field:"kubernetes.node.memory.usage.bytes",id:"avg-memory-usage",type:"avg"}],split_mode:"everything"}]}),hostDockerOverview:(e,i,t)=>({id:"hostDockerOverview",requires:["docker.info"],index_pattern:i,interval:t,time_field:e,type:"top_n",series:[{id:"total",metrics:[{field:"docker.info.containers.total",id:"max-total",type:"max"}],split_mode:"everything"},{id:"running",metrics:[{field:"docker.info.containers.running",id:"max-running",type:"max"}],split_mode:"everything"},{id:"paused",metrics:[{field:"docker.info.containers.paused",id:"max-paused",type:"max"}],split_mode:"everything"},{id:"stopped",metrics:[{field:"docker.info.containers.stopped",id:"max-stopped",type:"max"}],split_mode:"everything"}]}),hostDockerInfo:(e,i,t)=>({id:"hostDockerInfo",requires:["docker.info"],index_pattern:i,interval:t,time_field:e,type:"timeseries",series:[{id:"running",metrics:[{field:"docker.info.containers.running",id:"max-running",type:"max"}],split_mode:"everything"},{id:"paused",metrics:[{field:"docker.info.containers.paused",id:"max-paused",type:"max"}],split_mode:"everything"},{id:"stopped",metrics:[{field:"docker.info.containers.stopped",id:"max-stopped",type:"max"}],split_mode:"everything"}]}),hostDockerTop5ByMemory:(e,i,t)=>({id:"hostDockerTop5ByMemory",requires:["docker.memory"],index_pattern:i,interval:t,time_field:e,type:"timeseries",series:[{id:"avg-memory",metrics:[{field:"docker.memory.usage.pct",id:"avg-memory-metric",type:"avg"}],split_mode:"terms",terms_field:"container.name",terms_order_by:"avg-memory",terms_size:5}]}),hostDockerTop5ByCpu:(e,i,t)=>({id:"hostDockerTop5ByCpu",requires:["docker.cpu"],index_pattern:i,interval:t,time_field:e,type:"timeseries",series:[{id:"avg-cpu",metrics:[{field:"docker.cpu.total.pct",id:"avg-cpu-metric",type:"avg"}],split_mode:"terms",terms_field:"container.name",terms_order_by:"avg-cpu",terms_size:5}]})},snapshot:a,defaultSnapshot:"cpu",defaultTimeRangeInSeconds:3600}},200:function(e,i,t){"use strict";t.d(i,"a",(function(){return r})),t.d(i,"b",(function(){return d}));const s=(e,i,t)=>({[`${e}_interfaces`]:{terms:{field:t},aggregations:{[`${e}_interface_max`]:{max:{field:i}}}},[`${e}_sum_of_interfaces`]:{sum_bucket:{buckets_path:`${e}_interfaces>${e}_interface_max`}},[`${e}_deriv`]:{derivative:{buckets_path:`${e}_sum_of_interfaces`,gap_policy:"skip",unit:"1s"}},[e]:{bucket_script:{buckets_path:{value:`${e}_deriv[normalized_value]`},script:{source:"params.value > 0.0 ? params.value : 0.0",lang:"painless"},gap_policy:"skip"}}}),a={cpu:{cpu:{avg:{field:"docker.cpu.total.pct"}}},memory:{memory:{avg:{field:"docker.memory.usage.pct"}}},rx:s("rx","docker.network.inbound.bytes","docker.network.interface"),tx:s("tx","docker.network.outbound.bytes","docker.network.interface")},r=Object.keys(a),d={tsvb:{containerOverview:(e,i,t)=>({id:"containerOverview",requires:["docker"],index_pattern:i,interval:t,time_field:e,type:"timeseries",series:[{id:"cpu",split_mode:"everything",metrics:[{field:"docker.cpu.total.pct",id:"avg-cpu-total",type:"avg"}]},{id:"memory",split_mode:"everything",metrics:[{field:"docker.memory.usage.pct",id:"avg-memory",type:"avg"}]},{id:"tx",split_mode:"everything",metrics:[{field:"docker.network.out.bytes",id:"avg-network-out",type:"avg"}]},{id:"rx",split_mode:"everything",metrics:[{field:"docker.network.in.bytes",id:"avg-network-in",type:"avg"}]}]}),containerCpuUsage:(e,i,t)=>({id:"containerCpuUsage",requires:["docker.cpu"],index_pattern:i,interval:t,time_field:e,type:"timeseries",series:[{id:"cpu",split_mode:"everything",metrics:[{field:"docker.cpu.total.pct",id:"avg-cpu-total",type:"avg"}]}]}),containerCpuKernel:(e,i,t)=>({id:"containerCpuKernel",requires:["docker.cpu"],index_pattern:i,interval:t,time_field:e,type:"timeseries",series:[{id:"kernel",split_mode:"everything",metrics:[{field:"docker.cpu.kernel.pct",id:"avg-cpu-kernel",type:"avg"}]}]}),containerDiskIOOps:(e,i,t)=>({id:"containerDiskIOOps",requires:["docker.disk"],index_pattern:i,interval:t,time_field:e,type:"timeseries",series:[{id:"read",split_mode:"everything",metrics:[{field:"docker.diskio.read.ops",id:"max-diskio-read-ops",type:"max"},{field:"max-diskio-read-ops",id:"deriv-max-diskio-read-ops",type:"derivative",unit:"1s"},{id:"posonly-deriv-max-diskio-read-ops",type:"calculation",variables:[{id:"var-rate",name:"rate",field:"deriv-max-diskio-read-ops"}],script:"params.rate > 0.0 ? params.rate : 0.0"}]},{id:"write",split_mode:"everything",metrics:[{field:"docker.diskio.write.ops",id:"max-diskio-write-ops",type:"max"},{field:"max-diskio-write-ops",id:"deriv-max-diskio-write-ops",type:"derivative",unit:"1s"},{id:"posonly-deriv-max-diskio-write-ops",type:"calculation",variables:[{id:"var-rate",name:"rate",field:"deriv-max-diskio-write-ops"}],script:"params.rate > 0.0 ? params.rate : 0.0"},{id:"calc-invert-rate",script:"params.rate * -1",type:"calculation",variables:[{field:"posonly-deriv-max-diskio-write-ops",id:"var-rate",name:"rate"}]}]}]}),containerDiskIOBytes:(e,i,t)=>({id:"containerDiskIOBytes",requires:["docker.disk"],index_pattern:i,interval:t,time_field:e,type:"timeseries",series:[{id:"read",split_mode:"everything",metrics:[{field:"docker.diskio.read.bytes",id:"max-diskio-read-bytes",type:"max"},{field:"max-diskio-read-bytes",id:"deriv-max-diskio-read-bytes",type:"derivative",unit:"1s"},{id:"posonly-deriv-max-diskio-read-bytes",type:"calculation",variables:[{id:"var-rate",name:"rate",field:"deriv-max-diskio-read-bytes"}],script:"params.rate > 0.0 ? params.rate : 0.0"}]},{id:"write",split_mode:"everything",metrics:[{field:"docker.diskio.write.bytes",id:"max-diskio-write-bytes",type:"max"},{field:"max-diskio-write-bytes",id:"deriv-max-diskio-write-bytes",type:"derivative",unit:"1s"},{id:"posonly-deriv-max-diskio-write-bytes",type:"calculation",variables:[{id:"var-rate",name:"rate",field:"deriv-max-diskio-write-bytes"}],script:"params.rate > 0.0 ? params.rate : 0.0"},{id:"calc-invert-rate",script:"params.rate * -1",type:"calculation",variables:[{field:"posonly-deriv-max-diskio-write-bytes",id:"var-rate",name:"rate"}]}]}]}),containerNetworkTraffic:(e,i,t)=>({id:"containerNetworkTraffic",requires:["docker.network"],index_pattern:i,interval:t,time_field:e,type:"timeseries",series:[{id:"tx",metrics:[{field:"docker.network.outbound.bytes",id:"max-net-out",type:"max"},{field:"max-net-out",id:"deriv-max-net-out",type:"derivative",unit:"1s"},{id:"posonly-deriv-max-net-out",type:"calculation",variables:[{id:"var-rate",name:"rate",field:"deriv-max-net-out"}],script:"params.rate > 0.0 ? params.rate : 0.0"},{function:"sum",id:"seriesagg-sum",type:"series_agg"}],split_mode:"terms",terms_field:"docker.network.interface"},{id:"rx",metrics:[{field:"docker.network.inbound.bytes",id:"max-net-in",type:"max"},{field:"max-net-in",id:"deriv-max-net-in",type:"derivative",unit:"1s"},{id:"posonly-deriv-max-net-in",type:"calculation",variables:[{id:"var-rate",name:"rate",field:"deriv-max-net-in"}],script:"params.rate > 0.0 ? params.rate : 0.0"},{id:"calc-invert-rate",script:"params.rate * -1",type:"calculation",variables:[{field:"posonly-deriv-max-net-in",id:"var-rate",name:"rate"}]},{function:"sum",id:"seriesagg-sum",type:"series_agg"}],split_mode:"terms",terms_field:"docker.network.interface"}]}),containerMemory:(e,i,t)=>({id:"containerMemory",requires:["docker.memory"],index_pattern:i,interval:t,time_field:e,type:"timeseries",series:[{id:"memory",split_mode:"everything",metrics:[{field:"docker.memory.usage.pct",id:"avg-memory",type:"avg"}]}]}),containerK8sCpuUsage:(e,i,t)=>({id:"containerK8sCpuUsage",requires:["kubernetes.container"],index_pattern:i,interval:t,time_field:e,type:"timeseries",series:[{id:"cpu",split_mode:"everything",metrics:[{field:"kubernetes.container.cpu.usage.limit.pct",id:"avg-cpu",type:"avg"}]}]}),containerK8sOverview:(e,i,t)=>({id:"containerK8sOverview",requires:["kubernetes.container"],index_pattern:i,interval:t,time_field:e,type:"timeseries",series:[{id:"cpu",split_mode:"everything",metrics:[{field:"kubernetes.container.cpu.usage.limit.pct",id:"avg-cpu-total",type:"avg"}]},{id:"memory",split_mode:"everything",metrics:[{field:"kubernetes.container.memory.usage.limit.pct",id:"avg-memory-total",type:"avg"}]}]}),containerK8sMemoryUsage:(e,i,t)=>({id:"containerK8sMemoryUsage",requires:["kubernetes.container"],index_pattern:i,interval:t,time_field:e,type:"timeseries",series:[{id:"memory",split_mode:"everything",metrics:[{field:"kubernetes.container.memory.usage.limit.pct",id:"avg-memory",type:"avg"}]}]})},snapshot:a,defaultSnapshot:"cpu",defaultTimeRangeInSeconds:3600}},202:function(e,i,t){"use strict";t.d(i,"b",(function(){return r})),t.d(i,"a",(function(){return d}));const s=(e,i)=>({[`${e}_max`]:{max:{field:i}},[`${e}_deriv`]:{derivative:{buckets_path:`${e}_max`,gap_policy:"skip",unit:"1s"}},[e]:{bucket_script:{buckets_path:{value:`${e}_deriv[normalized_value]`},script:{source:"params.value > 0.0 ? params.value : 0.0",lang:"painless"},gap_policy:"skip"}}}),a={cpu:{cpu_with_limit:{avg:{field:"kubernetes.pod.cpu.usage.limit.pct"}},cpu_without_limit:{avg:{field:"kubernetes.pod.cpu.usage.node.pct"}},cpu:{bucket_script:{buckets_path:{with_limit:"cpu_with_limit",without_limit:"cpu_without_limit"},script:{source:"params.with_limit > 0.0 ? params.with_limit : params.without_limit",lang:"painless"},gap_policy:"skip"}}},memory:{memory_with_limit:{avg:{field:"kubernetes.pod.memory.usage.limit.pct"}},memory_without_limit:{avg:{field:"kubernetes.pod.memory.usage.node.pct"}},memory:{bucket_script:{buckets_path:{with_limit:"memory_with_limit",without_limit:"memory_without_limit"},script:{source:"params.with_limit > 0.0 ? params.with_limit : params.without_limit",lang:"painless"},gap_policy:"skip"}}},rx:s("rx","kubernetes.pod.network.rx.bytes"),tx:s("tx","kubernetes.pod.network.tx.bytes")},r=Object.keys(a),d={tsvb:{podOverview:(e,i,t)=>({id:"podOverview",requires:["kubernetes.pod"],index_pattern:i,interval:t,time_field:e,type:"timeseries",series:[{id:"cpu",split_mode:"everything",metrics:[{field:"kubernetes.pod.cpu.usage.node.pct",id:"avg-cpu-without",type:"avg"},{field:"kubernetes.pod.cpu.usage.limit.pct",id:"avg-cpu-with",type:"avg"},{id:"cpu-usage",type:"calculation",variables:[{id:"cpu_with",name:"with_limit",field:"avg-cpu-with"},{id:"cpu_without",name:"without_limit",field:"avg-cpu-without"}],script:"params.with_limit > 0.0 ? params.with_limit : params.without_limit"}]},{id:"memory",split_mode:"everything",metrics:[{field:"kubernetes.pod.memory.usage.node.pct",id:"avg-memory-without",type:"avg"},{field:"kubernetes.pod.memory.usage.limit.pct",id:"avg-memory-with",type:"avg"},{id:"memory-usage",type:"calculation",variables:[{id:"memory_with",name:"with_limit",field:"avg-memory-with"},{id:"memory_without",name:"without_limit",field:"avg-memory-without"}],script:"params.with_limit > 0.0 ? params.with_limit : params.without_limit"}]},{id:"rx",split_mode:"everything",metrics:[{field:"kubernetes.pod.network.rx.bytes",id:"max-network-rx",type:"max"},{field:"max-network-rx",id:"deriv-max-network-rx",type:"derivative",unit:"1s"},{id:"posonly-deriv-max-network-rx",type:"calculation",variables:[{id:"var-rate",name:"rate",field:"deriv-max-network-rx"}],script:"params.rate > 0.0 ? params.rate : 0.0"}]},{id:"tx",split_mode:"everything",metrics:[{field:"kubernetes.pod.network.tx.bytes",id:"max-network-tx",type:"max"},{field:"max-network-tx",id:"deriv-max-network-tx",type:"derivative",unit:"1s"},{id:"posonly-deriv-max-network-tx",type:"calculation",variables:[{id:"var-rate",name:"rate",field:"deriv-max-network-tx"}],script:"params.rate > 0.0 ? params.rate : 0.0"}]}]}),podCpuUsage:(e,i,t)=>({id:"podCpuUsage",requires:["kubernetes.pod"],index_pattern:i,interval:t,time_field:e,type:"timeseries",series:[{id:"cpu",split_mode:"everything",metrics:[{field:"kubernetes.pod.cpu.usage.node.pct",id:"avg-cpu-without",type:"avg"},{field:"kubernetes.pod.cpu.usage.limit.pct",id:"avg-cpu-with",type:"avg"},{id:"cpu-usage",type:"calculation",variables:[{id:"cpu_with",name:"with_limit",field:"avg-cpu-with"},{id:"cpu_without",name:"without_limit",field:"avg-cpu-without"}],script:"params.with_limit > 0.0 ? params.with_limit : params.without_limit"}]}]}),podLogUsage:(e,i,t)=>({id:"podLogUsage",requires:["kubernetes.pod"],index_pattern:i,interval:t,time_field:e,type:"timeseries",series:[{id:"logs",split_mode:"everything",metrics:[{field:"kubernetes.container.logs.used.bytes",id:"avg-log-used",type:"avg"},{field:"kubernetes.container.logs.capacity.bytes",id:"max-log-cap",type:"max"},{id:"calc-usage-limit",script:"params.usage / params.limit",type:"calculation",variables:[{field:"avg-log-userd",id:"var-usage",name:"usage"},{field:"max-log-cap",id:"var-limit",name:"limit"}]}]}]}),podNetworkTraffic:(e,i,t)=>({id:"podNetworkTraffic",requires:["kubernetes.pod"],index_pattern:i,interval:t,time_field:e,type:"timeseries",series:[{id:"tx",split_mode:"everything",metrics:[{field:"kubernetes.pod.network.tx.bytes",id:"max-network-tx",type:"max"},{field:"max-network-tx",id:"deriv-max-network-tx",type:"derivative",unit:"1s"},{id:"posonly-deriv-max-net-tx",type:"calculation",variables:[{id:"var-rate",name:"rate",field:"deriv-max-network-tx"}],script:"params.rate > 0.0 ? params.rate : 0.0"}]},{id:"rx",split_mode:"everything",metrics:[{field:"kubernetes.pod.network.rx.bytes",id:"max-network-rx",type:"max"},{field:"max-network-rx",id:"deriv-max-network-rx",type:"derivative",unit:"1s"},{id:"posonly-deriv-max-net-rx",type:"calculation",variables:[{id:"var-rate",name:"rate",field:"deriv-max-network-rx"}],script:"params.rate > 0.0 ? params.rate : 0.0"},{id:"invert-posonly-deriv-max-network-rx",script:"params.rate * -1",type:"calculation",variables:[{field:"posonly-deriv-max-net-rx",id:"var-rate",name:"rate"}]}]}]}),podMemoryUsage:(e,i,t)=>({id:"podMemoryUsage",requires:["kubernetes.pod"],index_pattern:i,interval:t,time_field:e,type:"timeseries",series:[{id:"memory",split_mode:"everything",metrics:[{field:"kubernetes.pod.memory.usage.node.pct",id:"avg-memory-without",type:"avg"},{field:"kubernetes.pod.memory.usage.limit.pct",id:"avg-memory-with",type:"avg"},{id:"memory-usage",type:"calculation",variables:[{id:"memory_with",name:"with_limit",field:"avg-memory-with"},{id:"memory_without",name:"without_limit",field:"avg-memory-without"}],script:"params.with_limit > 0.0 ? params.with_limit : params.without_limit"}]}]})},snapshot:a,defaultSnapshot:"cpu",defaultTimeRangeInSeconds:3600}},203:function(e,i,t){"use strict";t.d(i,"a",(function(){return p})),t.d(i,"b",(function(){return m}));var s=t(92);const a=Object(s.a)("awsS3BucketSize",["aws.s3_daily_storage"],[{id:"bytes",split_mode:"everything",metrics:[{field:"aws.s3_daily_storage.bucket.size.bytes",id:"max-bytes",type:"max"}]}],">=86400s",!1),r=Object(s.a)("awsS3TotalRequests",["aws.s3_request"],[{id:"total",split_mode:"everything",metrics:[{field:"aws.s3_request.requests.total",id:"max-size",type:"max"}]}],">=300s"),d=Object(s.a)("awsS3NumberOfObjects",["aws.s3_daily_storage"],[{id:"objects",split_mode:"everything",metrics:[{field:"aws.s3_daily_storage.number_of_objects",id:"max-size",type:"max"}]}],">=86400s",!1),n=Object(s.a)("awsS3DownloadBytes",["aws.s3_request"],[{id:"bytes",split_mode:"everything",metrics:[{field:"aws.s3_request.downloaded.bytes",id:"max-bytes",type:"max"}]}],">=300s"),o=Object(s.a)("awsS3UploadBytes",["aws.s3_request"],[{id:"bytes",split_mode:"everything",metrics:[{field:"aws.s3_request.uploaded.bytes",id:"max-bytes",type:"max"}]}],">=300s"),c={s3BucketSize:{s3BucketSize:{max:{field:"aws.s3_daily_storage.bucket.size.bytes"}}},s3NumberOfObjects:{s3NumberOfObjects:{max:{field:"aws.s3_daily_storage.number_of_objects"}}},s3TotalRequests:{s3TotalRequests:{max:{field:"aws.s3_request.requests.total"}}},s3UploadBytes:{s3UploadBytes:{max:{field:"aws.s3_request.uploaded.bytes"}}},s3DownloadBytes:{s3DownloadBytes:{max:{field:"aws.s3_request.downloaded.bytes"}}}},p=Object.keys(c),m={tsvb:{awsS3BucketSize:a,awsS3TotalRequests:r,awsS3NumberOfObjects:d,awsS3DownloadBytes:n,awsS3UploadBytes:o},snapshot:c,defaultSnapshot:"s3BucketSize",defaultTimeRangeInSeconds:604800}},204:function(e,i,t){"use strict";t.d(i,"a",(function(){return p})),t.d(i,"b",(function(){return m}));var s=t(92);const a=Object(s.a)("awsRDSLatency",["aws.rds"],[{id:"read",split_mode:"everything",metrics:[{field:"aws.rds.latency.read",id:"avg",type:"avg"}]},{id:"write",split_mode:"everything",metrics:[{field:"aws.rds.latency.write",id:"avg",type:"avg"}]},{id:"insert",split_mode:"everything",metrics:[{field:"aws.rds.latency.insert",id:"avg",type:"avg"}]},{id:"update",split_mode:"everything",metrics:[{field:"aws.rds.latency.update",id:"avg",type:"avg"}]},{id:"commit",split_mode:"everything",metrics:[{field:"aws.rds.latency.commit",id:"avg",type:"avg"}]}]),r=Object(s.a)("awsRDSConnections",["aws.rds"],[{id:"connections",split_mode:"everything",metrics:[{field:"aws.rds.database_connections",id:"avg-conns",type:"avg"}]}]),d=Object(s.a)("awsRDSCpuTotal",["aws.rds"],[{id:"cpu",split_mode:"everything",metrics:[{field:"aws.rds.cpu.total.pct",id:"avg-cpu",type:"avg"},{id:"convert-to-percent",script:"params.avg / 100",type:"calculation",variables:[{field:"avg-cpu",id:"var-avg",name:"avg"}]}]}]),n=Object(s.a)("awsRDSQueriesExecuted",["aws.rds"],[{id:"queries",split_mode:"everything",metrics:[{field:"aws.rds.queries",id:"avg-queries",type:"avg"}]}]),o=Object(s.a)("awsRDSActiveTransactions",["aws.rds"],[{id:"active",split_mode:"everything",metrics:[{field:"aws.rds.transactions.active",id:"avg",type:"avg"}]},{id:"blocked",split_mode:"everything",metrics:[{field:"aws.rds.transactions.blocked",id:"avg",type:"avg"}]}]),c={cpu:{cpu_avg:{avg:{field:"aws.rds.cpu.total.pct"}},cpu:{bucket_script:{buckets_path:{cpu:"cpu_avg"},script:{source:"params.cpu / 100",lang:"painless"},gap_policy:"skip"}}},rdsLatency:{rdsLatency:{avg:{field:"aws.rds.latency.dml"}}},rdsConnections:{rdsConnections:{avg:{field:"aws.rds.database_connections"}}},rdsQueriesExecuted:{rdsQueriesExecuted:{avg:{field:"aws.rds.queries"}}},rdsActiveTransactions:{rdsActiveTransactions:{avg:{field:"aws.rds.transactions.active"}}}},p=Object.keys(c),m={tsvb:{awsRDSLatency:a,awsRDSConnections:r,awsRDSCpuTotal:d,awsRDSQueriesExecuted:n,awsRDSActiveTransactions:o},snapshot:c,defaultSnapshot:"cpu",defaultTimeRangeInSeconds:14400}},205:function(e,i,t){"use strict";t.d(i,"a",(function(){return p})),t.d(i,"b",(function(){return m}));var s=t(92);const a=Object(s.a)("awsSQSMessagesVisible",["aws.sqs"],[{id:"visible",split_mode:"everything",metrics:[{field:"aws.sqs.messages.visible",id:"avg-visible",type:"avg"}]}],">=300s"),r=Object(s.a)("awsSQSMessagesDelayed",["aws.sqs"],[{id:"delayed",split_mode:"everything",metrics:[{field:"aws.sqs.messages.delayed",id:"avg-delayed",type:"avg"}]}],">=300s"),d=Object(s.a)("awsSQSMessagesSent",["aws.sqs"],[{id:"sent",split_mode:"everything",metrics:[{field:"aws.sqs.messages.sent",id:"avg-sent",type:"avg"}]}],">=300s"),n=Object(s.a)("awsSQSMessagesEmpty",["aws.sqs"],[{id:"empty",split_mode:"everything",metrics:[{field:"aws.sqs.messages.not_visible",id:"avg-empty",type:"avg"}]}],">=300s"),o=Object(s.a)("awsSQSOldestMessage",["aws.sqs"],[{id:"oldest",split_mode:"everything",metrics:[{field:"aws.sqs.oldest_message_age.sec",id:"max-oldest",type:"max"}]}],">=300s"),c={sqsMessagesVisible:{sqsMessagesVisible:{avg:{field:"aws.sqs.messages.visible"}}},sqsMessagesDelayed:{sqsMessagesDelayed:{max:{field:"aws.sqs.messages.delayed"}}},sqsMessagesEmpty:{sqsMessagesEmpty:{max:{field:"aws.sqs.messages.not_visible"}}},sqsMessagesSent:{sqsMessagesSent:{max:{field:"aws.sqs.messages.sent"}}},sqsOldestMessage:{sqsOldestMessage:{max:{field:"aws.sqs.oldest_message_age.sec"}}}},p=Object.keys(c),m={tsvb:{awsSQSMessagesVisible:a,awsSQSMessagesDelayed:r,awsSQSMessagesSent:d,awsSQSMessagesEmpty:n,awsSQSOldestMessage:o},snapshot:c,defaultSnapshot:"sqsMessagesVisible",defaultTimeRangeInSeconds:14400}},207:function(e,i,t){"use strict";t.d(i,"a",(function(){return o})),t.d(i,"b",(function(){return c}));var s=t(92);const a=Object(s.a)("awsEC2CpuUtilization",["aws.ec2"],[{id:"total",split_mode:"everything",metrics:[{field:"aws.ec2.cpu.total.pct",id:"avg-cpu",type:"avg"},{id:"convert-to-percent",script:"params.avg / 100",type:"calculation",variables:[{field:"avg-cpu",id:"var-avg",name:"avg"}]}]}]),r=Object(s.a)("awsEC2NetworkTraffic",["aws.ec2"],[{id:"tx",split_mode:"everything",metrics:[{field:"aws.ec2.network.out.bytes_per_sec",id:"avg-tx",type:"avg"}]},{id:"rx",split_mode:"everything",metrics:[{field:"aws.ec2.network.in.bytes_per_sec",id:"avg-rx",type:"avg"},{id:"calculation-rate",type:"calculation",variables:[{id:"rate-var",name:"rate",field:"avg-rx"}],script:"params.rate * -1"}]}]),d=Object(s.a)("awsEC2DiskIOBytes",["aws.ec2"],[{id:"write",split_mode:"everything",metrics:[{field:"aws.ec2.diskio.write.bytes_per_sec",id:"avg-write",type:"avg"}]},{id:"read",split_mode:"everything",metrics:[{field:"aws.ec2.diskio.read.bytes_per_sec",id:"avg-read",type:"avg"},{id:"calculation-rate",type:"calculation",variables:[{id:"rate-var",name:"rate",field:"avg-read"}],script:"params.rate * -1"}]}]),n={cpu:{cpu_avg:{avg:{field:"aws.ec2.cpu.total.pct"}},cpu:{bucket_script:{buckets_path:{cpu:"cpu_avg"},script:{source:"params.cpu / 100",lang:"painless"},gap_policy:"skip"}}},rx:{rx:{avg:{field:"aws.ec2.network.in.bytes_per_sec"}}},tx:{tx:{avg:{field:"aws.ec2.network.in.bytes_per_sec"}}},diskIOReadBytes:{diskIOReadBytes:{avg:{field:"aws.ec2.diskio.read.bytes_per_sec"}}},diskIOWriteBytes:{diskIOWriteBytes:{avg:{field:"aws.ec2.diskio.write.bytes_per_sec"}}}},o=Object.keys(n),c={tsvb:{awsEC2CpuUtilization:a,awsEC2NetworkTraffic:r,awsEC2DiskIOBytes:d},snapshot:n,defaultSnapshot:"cpu",defaultTimeRangeInSeconds:14400}},220:function(e,i,t){"use strict";t.d(i,"a",(function(){return d}));var s=t(1),a=t(199),r=t(276);t.d(i,"b",(function(){return a.a}));const d={id:"host",displayName:s.i18n.translate("xpack.infra.inventoryModel.host.displayName",{defaultMessage:"Hosts"}),singularDisplayName:s.i18n.translate("xpack.infra.inventoryModels.host.singularDisplayName",{defaultMessage:"Host"}),requiredModule:"system",crosslinkSupport:{details:!0,logs:!0,apm:!0,uptime:!0},fields:{id:"host.name",name:"host.name",os:"host.os.name",ip:"host.ip",cloudProvider:"cloud.provider"},metrics:a.b,requiredMetrics:["hostSystemOverview","hostCpuUsage","hostLoad","hostMemoryUsage","hostNetworkTraffic","hostK8sOverview","hostK8sCpuCap","hostK8sMemoryCap","hostK8sDiskCap","hostK8sPodCap",...r.a,...r.b],tooltipMetrics:["cpu","memory","tx","rx"]}},221:function(e,i,t){"use strict";t.d(i,"a",(function(){return d}));var s=t(1),a=t(202),r=t(276);t.d(i,"b",(function(){return a.b}));const d={id:"pod",displayName:s.i18n.translate("xpack.infra.inventoryModel.pod.displayName",{defaultMessage:"Kubernetes Pods"}),singularDisplayName:s.i18n.translate("xpack.infra.inventoryModels.pod.singularDisplayName",{defaultMessage:"Kubernetes Pod"}),requiredModule:"kubernetes",crosslinkSupport:{details:!0,logs:!0,apm:!0,uptime:!0},fields:{id:"kubernetes.pod.uid",name:"kubernetes.pod.name",ip:"kubernetes.pod.ip"},metrics:a.a,requiredMetrics:["podOverview","podCpuUsage","podMemoryUsage","podNetworkTraffic",...r.b],tooltipMetrics:["cpu","memory","rx","tx"]}},222:function(e,i,t){"use strict";t.d(i,"a",(function(){return r}));var s=t(1),a=t(207);t.d(i,"b",(function(){return a.a}));const r={id:"awsEC2",displayName:s.i18n.translate("xpack.infra.inventoryModels.awsEC2.displayName",{defaultMessage:"EC2 Instances"}),singularDisplayName:s.i18n.translate("xpack.infra.inventoryModels.awsEC2.singularDisplayName",{defaultMessage:"EC2 Instance"}),requiredModule:"aws",crosslinkSupport:{details:!0,logs:!0,apm:!0,uptime:!0},metrics:a.b,fields:{id:"cloud.instance.id",name:"cloud.instance.name",ip:"aws.ec2.instance.public.ip"},requiredMetrics:["awsEC2CpuUtilization","awsEC2NetworkTraffic","awsEC2DiskIOBytes"],tooltipMetrics:["cpu","rx","tx"],nodeFilter:[{term:{"event.dataset":"aws.ec2"}}]}},223:function(e,i,t){"use strict";t.d(i,"a",(function(){return r}));var s=t(1),a=t(203);t.d(i,"b",(function(){return a.a}));const r={id:"awsS3",displayName:s.i18n.translate("xpack.infra.inventoryModels.awsS3.displayName",{defaultMessage:"S3 Buckets"}),singularDisplayName:s.i18n.translate("xpack.infra.inventoryModels.awsS3.singularDisplayName",{defaultMessage:"S3 Bucket"}),requiredModule:"aws",crosslinkSupport:{details:!0,logs:!0,apm:!1,uptime:!1},metrics:a.b,fields:{id:"aws.s3.bucket.name",name:"aws.s3.bucket.name"},requiredMetrics:["awsS3BucketSize","awsS3NumberOfObjects","awsS3TotalRequests","awsS3DownloadBytes","awsS3UploadBytes"],tooltipMetrics:["s3BucketSize","s3NumberOfObjects","s3TotalRequests","s3UploadBytes","s3DownloadBytes"]}},224:function(e,i,t){"use strict";t.d(i,"a",(function(){return r}));var s=t(1),a=t(204);t.d(i,"b",(function(){return a.a}));const r={id:"awsRDS",displayName:s.i18n.translate("xpack.infra.inventoryModels.awsRDS.displayName",{defaultMessage:"RDS Databases"}),singularDisplayName:s.i18n.translate("xpack.infra.inventoryModels.awsRDS.singularDisplayName",{defaultMessage:"RDS Database"}),requiredModule:"aws",crosslinkSupport:{details:!0,logs:!0,apm:!1,uptime:!1},metrics:a.b,fields:{id:"aws.rds.db_instance.arn",name:"aws.rds.db_instance.identifier"},requiredMetrics:["awsRDSCpuTotal","awsRDSConnections","awsRDSQueriesExecuted","awsRDSActiveTransactions","awsRDSLatency"],tooltipMetrics:["cpu","rdsLatency","rdsConnections","rdsQueriesExecuted","rdsActiveTransactions"]}},225:function(e,i,t){"use strict";t.d(i,"a",(function(){return r}));var s=t(1),a=t(205);t.d(i,"b",(function(){return a.a}));const r={id:"awsSQS",displayName:s.i18n.translate("xpack.infra.inventoryModels.awsSQS.displayName",{defaultMessage:"SQS Queues"}),singularDisplayName:s.i18n.translate("xpack.infra.inventoryModels.awsSQS.singularDisplayName",{defaultMessage:"SQS Queue"}),requiredModule:"aws",crosslinkSupport:{details:!0,logs:!0,apm:!1,uptime:!1},metrics:a.b,fields:{id:"aws.sqs.queue.name",name:"aws.sqs.queue.name"},requiredMetrics:["awsSQSMessagesVisible","awsSQSMessagesDelayed","awsSQSMessagesSent","awsSQSMessagesEmpty","awsSQSOldestMessage"],tooltipMetrics:["sqsMessagesVisible","sqsMessagesDelayed","sqsMessagesEmpty","sqsMessagesSent","sqsOldestMessage"]}},226:function(e,i,t){"use strict";t.d(i,"a",(function(){return r}));var s=t(1),a=t(200);t.d(i,"b",(function(){return a.a}));const r={id:"container",displayName:s.i18n.translate("xpack.infra.inventoryModel.container.displayName",{defaultMessage:"Docker Containers"}),singularDisplayName:s.i18n.translate("xpack.infra.inventoryModel.container.singularDisplayName",{defaultMessage:"Docker Container"}),requiredModule:"docker",crosslinkSupport:{details:!0,logs:!0,apm:!0,uptime:!0},fields:{id:"container.id",name:"container.name",ip:"container.ip_address"},metrics:a.b,requiredMetrics:["containerOverview","containerCpuUsage","containerMemory","containerNetworkTraffic","containerDiskIOBytes","containerDiskIOOps","containerK8sOverview","containerK8sCpuUsage","containerK8sMemoryUsage"],tooltipMetrics:["cpu","memory","rx","tx"]}},255:function(e,i,t){"use strict";t.d(i,"a",(function(){return p}));var s=t(199);t(275).a;var a=t(202),r=t(200),d=t(207),n=t(203),o=t(204),c=t(205);const p={tsvb:{...s.b.tsvb,nginxActiveConnections:(e,i,t)=>({id:"nginxActiveConnections",requires:["nginx.stubstatus"],index_pattern:i,interval:t,time_field:e,type:"timeseries",series:[{id:"connections",metrics:[{field:"nginx.stubstatus.active",id:"avg-active",type:"avg"}],split_mode:"everything"}]}),nginxHits:(e,i,t)=>({id:"nginxHits",requires:["nginx.access"],index_pattern:i,interval:t,time_field:e,type:"timeseries",series:[{id:"200s",metrics:[{id:"count-200",type:"count"}],split_mode:"filter",filter:{query:"http.response.status_code:[200 TO 299]",language:"lucene"}},{id:"300s",metrics:[{id:"count-300",type:"count"}],split_mode:"filter",filter:{query:"http.response.status_code:[300 TO 399]",language:"lucene"}},{id:"400s",metrics:[{id:"count-400",type:"count"}],split_mode:"filter",filter:{query:"http.response.status_code:[400 TO 499]",language:"lucene"}},{id:"500s",metrics:[{id:"count-500",type:"count"}],split_mode:"filter",filter:{query:"http.response.status_code:[500 TO 599]",language:"lucene"}}]}),nginxRequestRate:(e,i,t)=>({id:"nginxRequestRate",requires:["nginx.stubstatus"],index_pattern:i,interval:t,time_field:e,type:"timeseries",series:[{id:"rate",metrics:[{field:"nginx.stubstatus.requests",id:"max-requests",type:"max"},{field:"max-requests",id:"derv-max-requests",type:"derivative",unit:"1s"},{id:"posonly-derv-max-requests",type:"calculation",variables:[{id:"var-rate",name:"rate",field:"derv-max-requests"}],script:"params.rate > 0.0 ? params.rate : 0.0"}],split_mode:"everything"}]}),nginxRequestsPerConnection:(e,i,t)=>({id:"nginxRequestsPerConnection",requires:["nginx.stubstatus"],index_pattern:i,interval:t,time_field:e,type:"timeseries",series:[{id:"reqPerConns",metrics:[{field:"nginx.stubstatus.handled",id:"max-handled",type:"max"},{field:"nginx.stubstatus.requests",id:"max-requests",type:"max"},{id:"reqs-per-connection",type:"calculation",variables:[{id:"var-handled",name:"handled",field:"max-handled"},{id:"var-requests",name:"requests",field:"max-requests"}],script:"params.handled > 0.0 && params.requests > 0.0 ? params.handled / params.requests : 0.0"}],split_mode:"everything"}]}),awsCpuUtilization:(e,i)=>({id:"awsCpuUtilization",requires:["aws.ec2"],map_field_to:"cloud.instance.id",id_type:"cloud",index_pattern:i,interval:">=5m",time_field:e,type:"timeseries",series:[{id:"cpu-util",metrics:[{field:"aws.ec2.cpu.total.pct",id:"avg-cpu-util",type:"avg"}],split_mode:"everything"}]}),awsDiskioBytes:(e,i)=>({id:"awsDiskioBytes",requires:["aws.ec2"],index_pattern:i,map_field_to:"cloud.instance.id",id_type:"cloud",interval:">=5m",time_field:e,type:"timeseries",series:[{id:"writes",metrics:[{field:"aws.ec2.diskio.write.bytes",id:"sum-diskio-out",type:"sum"},{id:"csum-sum-diskio-out",field:"sum-diskio-out",type:"cumulative_sum"},{id:"deriv-csum-sum-diskio-out",unit:"1s",type:"derivative",field:"csum-sum-diskio-out"},{id:"posonly-deriv-csum-sum-diskio-out",field:"deriv-csum-sum-diskio-out",type:"positive_only"}],split_mode:"everything"},{id:"reads",metrics:[{field:"aws.ec2.diskio.read.bytes",id:"sum-diskio-in",type:"sum"},{id:"csum-sum-diskio-in",field:"sum-diskio-in",type:"cumulative_sum"},{id:"deriv-csum-sum-diskio-in",unit:"1s",type:"derivative",field:"csum-sum-diskio-in"},{id:"posonly-deriv-csum-sum-diskio-in",field:"deriv-csum-sum-diskio-in",type:"positive_only"},{id:"inverted-posonly-deriv-csum-sum-diskio-in",type:"calculation",variables:[{id:"var-rate",name:"rate",field:"posonly-deriv-csum-sum-diskio-in"}],script:"params.rate * -1"}],split_mode:"everything"}]}),awsDiskioOps:(e,i)=>({id:"awsDiskioOps",requires:["aws.ec2"],index_pattern:i,map_field_to:"cloud.instance.id",id_type:"cloud",interval:">=5m",time_field:e,type:"timeseries",series:[{id:"writes",metrics:[{field:"aws.ec2.diskio.write.count",id:"sum-diskio-writes",type:"sum"},{id:"csum-sum-diskio-writes",field:"sum-diskio-writes",type:"cumulative_sum"},{id:"deriv-csum-sum-diskio-writes",unit:"1s",type:"derivative",field:"csum-sum-diskio-writes"},{id:"posonly-deriv-csum-sum-diskio-writes",field:"deriv-csum-sum-diskio-writes",type:"positive_only"}],split_mode:"everything"},{id:"reads",metrics:[{field:"aws.ec2.diskio.read.count",id:"sum-diskio-reads",type:"sum"},{id:"csum-sum-diskio-reads",field:"sum-diskio-reads",type:"cumulative_sum"},{id:"deriv-csum-sum-diskio-reads",unit:"1s",type:"derivative",field:"csum-sum-diskio-reads"},{id:"posonly-deriv-csum-sum-diskio-reads",field:"deriv-csum-sum-diskio-reads",type:"positive_only"},{id:"inverted-posonly-deriv-csum-sum-diskio-reads",type:"calculation",variables:[{id:"var-rate",name:"rate",field:"posonly-deriv-csum-sum-diskio-reads"}],script:"params.rate * -1"}],split_mode:"everything"}]}),awsNetworkBytes:(e,i)=>({id:"awsNetworkBytes",requires:["aws.ec2"],index_pattern:i,map_field_to:"cloud.instance.id",id_type:"cloud",interval:">=5m",time_field:e,type:"timeseries",series:[{id:"tx",metrics:[{field:"aws.ec2.network.out.bytes",id:"sum-net-out",type:"sum"},{id:"csum-sum-net-out",field:"sum-net-out",type:"cumulative_sum"},{id:"deriv-csum-sum-net-out",unit:"1s",type:"derivative",field:"csum-sum-net-out"},{id:"posonly-deriv-csum-sum-net-out",field:"deriv-csum-sum-net-out",type:"positive_only"}],split_mode:"everything"},{id:"rx",metrics:[{field:"aws.ec2.network.in.bytes",id:"sum-net-in",type:"sum"},{id:"csum-sum-net-in",field:"sum-net-in",type:"cumulative_sum"},{id:"deriv-csum-sum-net-in",unit:"1s",type:"derivative",field:"csum-sum-net-in"},{id:"posonly-deriv-csum-sum-net-in",field:"deriv-csum-sum-net-in",type:"positive_only"},{id:"inverted-posonly-deriv-csum-sum-net-in",type:"calculation",variables:[{id:"var-rate",name:"rate",field:"posonly-deriv-csum-sum-net-in"}],script:"params.rate * -1"}],split_mode:"everything"}]}),awsNetworkPackets:(e,i)=>({id:"awsNetworkPackets",requires:["aws.ec2"],index_pattern:i,map_field_to:"cloud.instance.id",id_type:"cloud",interval:">=5m",time_field:e,type:"timeseries",series:[{id:"packets-out",metrics:[{field:"aws.ec2.network.out.packets",id:"avg-net-out",type:"avg"}],split_mode:"everything"},{id:"packets-in",metrics:[{field:"aws.ec2.network.in.packets",id:"avg-net-in",type:"avg"},{id:"inverted-avg-net-in",type:"calculation",variables:[{id:"var-avg",name:"avg",field:"avg-net-in"}],script:"params.avg * -1"}],split_mode:"everything"}]}),awsOverview:(e,i)=>({id:"awsOverview",requires:["aws.ec2"],index_pattern:i,map_field_to:"cloud.instance.id",id_type:"cloud",interval:">=5m",time_field:e,type:"top_n",series:[{id:"cpu-util",split_mode:"everything",metrics:[{field:"aws.ec2.cpu.total.pct",id:"cpu-total-pct",type:"max"}]},{id:"status-check-failed",split_mode:"everything",metrics:[{field:"aws.ec2.status.check_failed",id:"status-check-failed",type:"max"}]},{id:"packets-out",split_mode:"everything",metrics:[{field:"aws.ec2.network.out.packets",id:"network-out-packets",type:"avg"}]},{id:"packets-in",split_mode:"everything",metrics:[{field:"aws.ec2.network.in.packets",id:"network-in-packets",type:"avg"}]}]}),...a.a.tsvb,...r.b.tsvb,...d.b.tsvb,...n.b.tsvb,...o.b.tsvb,...c.b.tsvb}}},275:function(e,i,t){"use strict";t.d(i,"a",(function(){return s}));const s={count:{bucket_script:{buckets_path:{count:"_count"},script:{source:"count * 1",lang:"expression"},gap_policy:"skip"}}}},276:function(e,i,t){"use strict";t.d(i,"b",(function(){return s})),t.d(i,"a",(function(){return a}));const s=["nginxHits","nginxRequestRate","nginxActiveConnections","nginxRequestsPerConnection"],a=["awsOverview","awsCpuUtilization","awsNetworkBytes","awsNetworkPackets","awsDiskioOps","awsDiskioBytes"]},89:function(e,i,t){"use strict";t.d(i,"b",(function(){return o})),t.d(i,"a",(function(){return CanceledPromiseError}));var s=t(7),a=t.n(s),r=t(2),d=t(120),n=t.n(d);const o=({createPromise:e,onResolve:i=c,onReject:t=c,cancelPreviousOn:s="never",triggerOrThrow:a="whenMounted"},d)=>{const o=n()(),p=Object(r.useCallback)((()=>{switch(a){case"always":return!0;case"whenMounted":return o()}}),[o,a]),m=Object(r.useRef)([]),[l,u]=Object(r.useState)({state:"uninitialized"}),y=Object(r.useCallback)((()=>{u({state:"uninitialized"})}),[]),v=Object(r.useMemo)((()=>(...a)=>{let r;const d=new Promise(((e,i)=>{r=i})),n=m.current,o=()=>{n.forEach((e=>e.cancel()))},l=e(...a),y=Promise.race([l,d]);u({state:"pending",promise:y}),"creation"===s&&o();const v={cancel:()=>{r(new CanceledPromiseError)},cancelSilently:()=>{r(new SilentCanceledPromiseError)},promise:y.then((e=>(["settlement","resolution"].includes(s)&&o(),m.current=m.current.filter((e=>e.promise!==v.promise)),i&&p()&&i(e),u((i=>"pending"===i.state&&i.promise===y?{state:"resolved",promise:v.promise,value:e}:i)),e)),(e=>{if(!(e instanceof SilentCanceledPromiseError)){if(["settlement","rejection"].includes(s)&&o(),m.current=m.current.filter((e=>e.promise!==v.promise)),p()){if(!t)throw e;t(e)}u((i=>"pending"===i.state&&i.promise===y?{state:"rejected",promise:y,value:e}:i))}}))};return m.current=[...m.current,v],v.promise.catch(c),v.promise}),d);return Object(r.useEffect)((()=>()=>{m.current.forEach((e=>e.cancelSilently()))}),[]),[l,v,y]};class CanceledPromiseError extends Error{constructor(e){super(e),a()(this,"isCanceled",!0),Object.setPrototypeOf(this,new.target.prototype)}}class SilentCanceledPromiseError extends CanceledPromiseError{}const c=()=>{}},91:function(e,i,t){"use strict";t.d(i,"d",(function(){return l})),t.d(i,"b",(function(){return u})),t.d(i,"c",(function(){return v})),t.d(i,"a",(function(){return g}));var s=t(1),a=t(10),r=t(220),d=t(221),n=t(222),o=t(223),c=t(224),p=t(225),m=t(226);t(255);const l=[r.a,d.a,m.a,n.a,o.a,c.a,p.a],u=e=>{const i=l.find((i=>i.id===e));if(!i)throw new Error(s.i18n.translate("xpack.infra.inventoryModels.findInventoryModel.error",{defaultMessage:"The inventory model you've attempted to find does not exist"}));return i},y=["host","pod","container"],v=e=>{switch(e){case"pod":return a.h;case"host":return a.b;case"container":return a.a}},g=e=>{const i=u(e);if(y.includes(e)){const t=v(e)||i.fields.id;return{...i.fields,id:t}}return i.fields}},92:function(e,i,t){"use strict";t.d(i,"a",(function(){return s}));const s=(e,i,t,s=">=300s",a=!0)=>(r,d)=>({id:e,requires:i,drop_last_bucket:a,index_pattern:d,interval:s,time_field:r,type:"timeseries",series:t})},96:function(e,i,t){"use strict";t.d(i,"a",(function(){return o}));var s=t(33),a=t(2),r=t(18),d=t(58),n=t(61);const o=({defaultState:e,decodeUrlState:i,encodeUrlState:t,urlStateKey:s,writeDefaultState:r=!1})=>{const n=Object(d.useHistory)(),o=null!=n&&n.location?p(n.location):"",y=Object(a.useMemo)((()=>{if(o)return m(o,s)}),[o,s]),v=Object(a.useMemo)((()=>i(c(y))),[i,y]),g=Object(a.useMemo)((()=>void 0!==v?v:e),[e,v]),f=Object(a.useCallback)((e=>{if(!n||!n.location)return;const i=n.location,a=u(i,l(s,void 0!==e?t(e):void 0)(p(i)));a!==i&&n.replace(a)}),[t,n,s]),[_,k]=Object(a.useState)(r&&void 0===v);return Object(a.useEffect)((()=>{_&&(k(!1),f(e))}),[_,f,e]),[g,f]},c=e=>{try{return e?Object(r.decode)(e):void 0}catch(e){if(e instanceof Error&&e.message.startsWith("rison decoder error"))return{};throw e}},p=e=>e.search.substring(1),m=(e,i)=>{const t=Object(s.parse)(e,{sort:!1})[i];return Array.isArray(t)?t[0]:t},l=(e,i)=>t=>{const a=Object(s.parse)(t,{sort:!1}),d=void 0===i?a:{...a,[e]:(o=i,Object(r.encode)(o))};var o;return Object(s.stringify)(n.url.encodeQuery(d),{sort:!1,encode:!1})},u=(e,i)=>i===p(e)?e:{...e,search:`?${i}`}}}]);