"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.hasFilters = exports.assertQueryStructure = void 0;
var _boom = _interopRequireDefault(require("@hapi/boom"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const validClauses = ['must', 'filter', 'must_not', 'should'];
const isValidFilter = query => {
  const boolClause = query.bool;
  if (!boolClause || Object.keys(boolClause).length === 0) {
    return false;
  }
  return [boolClause.filter, boolClause.must, boolClause.must_not, boolClause.should].filter(Boolean).every(clause => Array.isArray(clause) || clause === undefined);
};
const assertQueryStructure = query => {
  if (!isValidFilter(query)) {
    throw _boom.default.badRequest('Invalid query');
  }
};
exports.assertQueryStructure = assertQueryStructure;
const hasFilters = query => {
  if (!query) {
    return false;
  }
  assertQueryStructure(query);

  // ignores minimum_should_match
  return Object.entries(query.bool).filter(([key, _]) => validClauses.includes(key)).some(([_, filter]) => {
    return Array.isArray(filter) ? filter.length > 0 : !!filter;
  });
};
exports.hasFilters = hasFilters;