"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HostsNameBucketRT = exports.HostsMetricsSearchValueRT = exports.HostsMetricsSearchBucketRT = exports.HostsMetricsSearchAggregationResponseRT = exports.FilteredMetricsTypeRT = exports.FilteredHostsSearchAggregationResponseRT = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _types = require("../../../lib/metrics/types");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FilteredMetricsTypeRT = rt.type({
  doc_count: rt.number,
  result: _types.BasicMetricValueRT
});
exports.FilteredMetricsTypeRT = FilteredMetricsTypeRT;
const HostsMetricsSearchValueRT = rt.union([_types.BasicMetricValueRT, FilteredMetricsTypeRT, _types.TopMetricsTypeRT]);
exports.HostsMetricsSearchValueRT = HostsMetricsSearchValueRT;
const HostsMetricsSearchBucketRT = rt.record(rt.union([rt.string, rt.undefined]), rt.union([rt.string, rt.number, HostsMetricsSearchValueRT, rt.record(rt.string, rt.string), rt.type({
  doc_count: rt.number
})]));
exports.HostsMetricsSearchBucketRT = HostsMetricsSearchBucketRT;
const HostsNameBucketRT = rt.type({
  key: rt.string,
  doc_count: rt.number
});
exports.HostsNameBucketRT = HostsNameBucketRT;
const HostsMetricsSearchAggregationResponseRT = rt.union([rt.type({
  nodes: rt.intersection([rt.partial({
    sum_other_doc_count: rt.number,
    doc_count_error_upper_bound: rt.number
  }), rt.type({
    buckets: rt.array(HostsMetricsSearchBucketRT)
  })])
}), rt.undefined]);
exports.HostsMetricsSearchAggregationResponseRT = HostsMetricsSearchAggregationResponseRT;
const FilteredHostsSearchAggregationResponseRT = rt.union([rt.type({
  nodes: rt.intersection([rt.partial({
    sum_other_doc_count: rt.number,
    doc_count_error_upper_bound: rt.number
  }), rt.type({
    buckets: rt.array(HostsNameBucketRT)
  })])
}), rt.undefined]);
exports.FilteredHostsSearchAggregationResponseRT = FilteredHostsSearchAggregationResponseRT;