"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initInfraMetricsRoute = void 0;
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _ioTsUtils = require("@kbn/io-ts-utils");
var _infra = require("../../../common/http_api/infra");
var _get_hosts = require("./lib/host/get_hosts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initInfraMetricsRoute = libs => {
  const validateBody = (0, _ioTsUtils.createRouteValidationFunction)(_infra.GetInfraMetricsRequestBodyPayloadRT);
  const {
    framework
  } = libs;
  framework.registerRoute({
    method: 'post',
    path: '/api/metrics/infra',
    validate: {
      body: validateBody
    }
  }, async (_, request, response) => {
    const [{
      savedObjects
    }, {
      data
    }] = await libs.getStartServices();
    const params = request.body;
    try {
      const searchClient = data.search.asScoped(request);
      const soClient = savedObjects.getScopedClient(request);
      const source = await libs.sources.getSourceConfiguration(soClient, params.sourceId);
      const hosts = await (0, _get_hosts.getHosts)({
        searchClient,
        sourceConfig: source.configuration,
        params
      });
      return response.ok({
        body: _infra.GetInfraMetricsResponsePayloadRT.encode(hosts)
      });
    } catch (err) {
      var _err$statusCode, _err$message;
      if (_boom.default.isBoom(err)) {
        return response.customError({
          statusCode: err.output.statusCode,
          body: {
            message: err.output.payload.message
          }
        });
      }
      return response.customError({
        statusCode: (_err$statusCode = err.statusCode) !== null && _err$statusCode !== void 0 ? _err$statusCode : 500,
        body: {
          message: (_err$message = err.message) !== null && _err$message !== void 0 ? _err$message : 'An unexpected error occurred'
        }
      });
    }
  });
};
exports.initInfraMetricsRoute = initInfraMetricsRoute;