"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.replaceStateKeyInQueryString = exports.getQueryStringFromLocation = exports.getParamFromQueryString = exports.decodeRisonUrlState = exports.UrlStateContainer = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _queryString = require("query-string");
var _react = _interopRequireDefault(require("react"));
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _rison = require("@kbn/rison");
var _public = require("@kbn/kibana-utils-plugin/public");
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class UrlStateContainerLifecycle extends _react.default.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "replaceStateInLocation", (0, _lodash.throttle)(urlState => {
      const {
        history,
        location,
        urlStateKey
      } = this.props;
      const newLocation = replaceQueryStringInLocation(location, replaceStateKeyInQueryString(urlStateKey, urlState)(getQueryStringFromLocation(location)));
      if (newLocation !== location) {
        history.replace(newLocation);
      }
    }, 1000));
    (0, _defineProperty2.default)(this, "handleInitialize", location => {
      const {
        onInitialize,
        mapToUrlState,
        urlStateKey,
        urlState
      } = this.props;
      if (!onInitialize || !mapToUrlState) {
        return;
      }
      const newUrlStateString = getParamFromQueryString(getQueryStringFromLocation(location), urlStateKey);
      const newUrlState = mapToUrlState(decodeRisonUrlState(newUrlStateString));

      // When the newURLState is empty we can assume that the state will becoming
      // from the urlState initially. By setting populateWithIntialState to true
      // this will now serialize the initial urlState into the URL when the page is
      // loaded.
      if (!newUrlState && this.props.populateWithInitialState) {
        this.replaceStateInLocation(urlState);
        onInitialize(urlState);
      } else {
        onInitialize(newUrlState);
      }
    });
    (0, _defineProperty2.default)(this, "handleLocationChange", (prevLocation, newLocation) => {
      const {
        onChange,
        mapToUrlState,
        urlStateKey
      } = this.props;
      if (!onChange || !mapToUrlState) {
        return;
      }
      const previousUrlStateString = getParamFromQueryString(getQueryStringFromLocation(prevLocation), urlStateKey);
      const newUrlStateString = getParamFromQueryString(getQueryStringFromLocation(newLocation), urlStateKey);
      if (previousUrlStateString !== newUrlStateString) {
        const previousUrlState = mapToUrlState(decodeRisonUrlState(previousUrlStateString));
        const newUrlState = mapToUrlState(decodeRisonUrlState(newUrlStateString));
        if (typeof newUrlState !== 'undefined') {
          onChange(newUrlState, previousUrlState);
        }
      }
    });
  }
  render() {
    return null;
  }
  componentDidUpdate({
    location: prevLocation,
    urlState: prevUrlState
  }) {
    const {
      history,
      location,
      urlState
    } = this.props;
    if (urlState !== prevUrlState) {
      this.replaceStateInLocation(urlState);
    }
    if (history.action === 'POP' && location !== prevLocation) {
      this.handleLocationChange(prevLocation, location);
    }
  }
  componentDidMount() {
    const {
      location
    } = this.props;
    this.handleInitialize(location);
  }
}
const UrlStateContainer = props => /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, null, ({
  history,
  location
}) => /*#__PURE__*/_react.default.createElement(UrlStateContainerLifecycle, (0, _extends2.default)({
  history: history,
  location: location
}, props)));
exports.UrlStateContainer = UrlStateContainer;
const decodeRisonUrlState = value => {
  try {
    return value ? (0, _rison.decode)(value) : undefined;
  } catch (error) {
    if (error instanceof Error && error.message.startsWith('rison decoder error')) {
      return {};
    }
    throw error;
  }
};
exports.decodeRisonUrlState = decodeRisonUrlState;
const encodeRisonUrlState = state => (0, _rison.encode)(state);
const getQueryStringFromLocation = location => location.search.substring(1);
exports.getQueryStringFromLocation = getQueryStringFromLocation;
const getParamFromQueryString = (queryString, key) => {
  const parsedQueryString = (0, _queryString.parse)(queryString, {
    sort: false
  });
  const queryParam = parsedQueryString[key];
  return Array.isArray(queryParam) ? queryParam[0] : queryParam;
};
exports.getParamFromQueryString = getParamFromQueryString;
const replaceStateKeyInQueryString = (stateKey, urlState) => queryString => {
  const previousQueryValues = (0, _queryString.parse)(queryString, {
    sort: false
  });
  const newValue = typeof urlState === 'undefined' ? previousQueryValues : {
    ...previousQueryValues,
    [stateKey]: encodeRisonUrlState(urlState)
  };
  return (0, _queryString.stringify)(_public.url.encodeQuery(newValue), {
    sort: false,
    encode: false
  });
};
exports.replaceStateKeyInQueryString = replaceStateKeyInQueryString;
const replaceQueryStringInLocation = (location, queryString) => {
  if (queryString === getQueryStringFromLocation(location)) {
    return location;
  } else {
    return {
      ...location,
      search: `?${queryString}`
    };
  }
};