"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.timefilterStateStorageKey = exports.createTimefilterStateStorage = void 0;
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const timefilterStateStorageKey = 'timefilter';
exports.timefilterStateStorageKey = timefilterStateStorageKey;
const createTimefilterStateStorage = ({
  timefilter
}) => {
  return {
    set: (key, state) => {
      if (key !== timefilterStateStorageKey) {
        return;
      }

      // TS doesn't narrow the overload arguments correctly
      const {
        timeRange,
        refreshInterval
      } = state;
      if (timeRange != null) {
        timefilter.setTime(timeRange);
      }
      if (refreshInterval != null) {
        timefilter.setRefreshInterval(refreshInterval);
      }
    },
    get: key => key === timefilterStateStorageKey ? getTimefilterState(timefilter) : null,
    change$: key => key === timefilterStateStorageKey ? (0, _rxjs.merge)(timefilter.getTimeUpdate$(), timefilter.getRefreshIntervalUpdate$()).pipe((0, _rxjs.map)(() => getTimefilterState(timefilter))) : (0, _rxjs.of)(null)
  };
};
exports.createTimefilterStateStorage = createTimefilterStateStorage;
const getTimefilterState = timefilter => ({
  timeRange: timefilter.getTime(),
  refreshInterval: timefilter.getRefreshInterval()
});