"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getChartTheme = getChartTheme;
exports.getTimelineChartTheme = getTimelineChartTheme;
var _charts = require("@elastic/charts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// TODO use the EUI charts theme see src/plugins/charts/public/services/theme/README.md
function getChartTheme(isDarkMode) {
  return isDarkMode ? _charts.DARK_THEME : _charts.LIGHT_THEME;
}
function getTimelineChartTheme(isDarkMode) {
  return isDarkMode ? _charts.DARK_THEME : (0, _charts.mergeWithDefaultTheme)(TIMELINE_LIGHT_THEME, _charts.LIGHT_THEME);
}
const TIMELINE_LIGHT_THEME = {
  crosshair: {
    band: {
      fill: '#D3DAE6'
    }
  },
  axes: {
    gridLine: {
      horizontal: {
        stroke: '#eaeaea'
      }
    }
  }
};