"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.normalizeDataSearchResponses = void 0;
var _rxjs = require("rxjs");
var _operators = require("rxjs/operators");
var _public = require("@kbn/kibana-utils-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * An operator factory that normalizes each {@link IKibanaSearchResponse} by
 * parsing it into a {@link ParsedKibanaSearchResponse} and adding initial
 * responses and error handling.
 *
 * @param initialResponse - The initial value to emit when a new request is
 * handled.
 * @param projectResponse - The projection function to apply to each response
 * payload. It should validate that the response payload is of the type {@link
 * RawResponse} and decode it to a {@link Response}.
 *
 * @return An operator that adds parsing and error handling transformations to
 * each response payload using the arguments given above.
 */
const normalizeDataSearchResponses = (initialResponse, parseRawResponse) => response$ => response$.pipe((0, _operators.map)(response => {
  var _response$isPartial, _response$isRunning;
  const {
    data,
    errors = []
  } = parseRawResponse(response.rawResponse);
  return {
    data,
    errors,
    isPartial: (_response$isPartial = response.isPartial) !== null && _response$isPartial !== void 0 ? _response$isPartial : false,
    isRunning: (_response$isRunning = response.isRunning) !== null && _response$isRunning !== void 0 ? _response$isRunning : false,
    loaded: response.loaded,
    total: response.total
  };
}), (0, _operators.startWith)({
  data: initialResponse,
  errors: [],
  isPartial: true,
  isRunning: true,
  loaded: 0,
  total: undefined
}), (0, _operators.catchError)(error => {
  var _error$message;
  return (0, _rxjs.of)({
    data: initialResponse,
    errors: [error instanceof _public.AbortError ? {
      type: 'aborted'
    } : {
      type: 'generic',
      message: `${(_error$message = error.message) !== null && _error$message !== void 0 ? _error$message : error}`
    }],
    isPartial: true,
    isRunning: false,
    loaded: 0,
    total: undefined
  });
}));
exports.normalizeDataSearchResponses = normalizeDataSearchResponses;