"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndicesConfigurationPanel = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _constants = require("../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const IndicesConfigurationPanel = ({
  isLoading,
  readOnly,
  metricAliasFieldProps
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
  size: "s"
}, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.infra.sourceConfiguration.indicesSectionTitle",
  defaultMessage: "Indices"
}))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "m"
}), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
  title: /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.sourceConfiguration.metricIndicesTitle",
    defaultMessage: "Metrics indices"
  })),
  description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.sourceConfiguration.metricIndicesDescription",
    defaultMessage: "Index pattern for matching indices that contain metrics data"
  })
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
  error: metricAliasFieldProps.error,
  fullWidth: true,
  helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.sourceConfiguration.metricIndicesRecommendedValue",
    defaultMessage: "The recommended value is {defaultValue}",
    values: {
      defaultValue: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, _constants.METRICS_INDEX_PATTERN)
    }
  }),
  isInvalid: metricAliasFieldProps.isInvalid,
  label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.sourceConfiguration.metricIndicesLabel",
    defaultMessage: "Metrics indices"
  })
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({
  "data-test-subj": "metricIndicesInput",
  fullWidth: true,
  disabled: isLoading,
  readOnly: readOnly,
  isLoading: isLoading
}, metricAliasFieldProps)))));
exports.IndicesConfigurationPanel = IndicesConfigurationPanel;