"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricsExplorerPage = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/observability-plugin/public");
var _use_metrics_breadcrumbs = require("../../../hooks/use_metrics_breadcrumbs");
var _empty_states = require("../../../components/empty_states");
var _charts = require("./components/charts");
var _toolbar = require("./components/toolbar");
var _use_metric_explorer_state = require("./hooks/use_metric_explorer_state");
var _metrics_source = require("../../../containers/metrics_source");
var _saved_view = require("../../../containers/saved_view/saved_view");
var _page_template = require("../page_template");
var _translations = require("../../../translations");
var _toolbar_control = require("../../../components/saved_views/toolbar_control");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MetricsExplorerPage = ({
  source,
  derivedIndexPattern
}) => {
  const [enabled, setEnabled] = (0, _react.useState)(false);
  const {
    isLoading,
    error,
    data,
    timeRange,
    options,
    chartOptions,
    setChartOptions,
    handleAggregationChange,
    handleMetricsChange,
    handleFilterQuerySubmit,
    handleGroupByChange,
    handleTimeChange,
    handleLoadMore,
    onViewStateChange,
    refresh
  } = (0, _use_metric_explorer_state.useMetricsExplorerState)(source, derivedIndexPattern, enabled);
  const {
    currentView,
    shouldLoadDefault
  } = (0, _saved_view.useSavedViewContext)();
  (0, _public.useTrackPageview)({
    app: 'infra_metrics',
    path: 'metrics_explorer'
  });
  (0, _public.useTrackPageview)({
    app: 'infra_metrics',
    path: 'metrics_explorer',
    delay: 15000
  });
  const {
    metricIndicesExist
  } = (0, _metrics_source.useSourceContext)();
  (0, _react.useEffect)(() => {
    if (currentView) {
      onViewStateChange(currentView);
    }
  }, [currentView, onViewStateChange]);
  (0, _react.useEffect)(() => {
    if (currentView != null || !shouldLoadDefault) {
      // load metrics explorer data after default view loaded, unless we're not isLoading a view
      setEnabled(true);
    }
  }, [currentView, shouldLoadDefault]);
  (0, _use_metrics_breadcrumbs.useMetricsBreadcrumbs)([{
    text: _translations.metricsExplorerTitle
  }]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiErrorBoundary, null, /*#__PURE__*/_react.default.createElement(_page_template.MetricsPageTemplate, {
    hasData: metricIndicesExist,
    pageHeader: {
      pageTitle: _translations.metricsExplorerTitle,
      rightSideItems: [/*#__PURE__*/_react.default.createElement(_toolbar_control.SavedViewsToolbarControls, {
        viewState: {
          options,
          chartOptions,
          currentTimerange: timeRange
        }
      })]
    }
  }, /*#__PURE__*/_react.default.createElement(_toolbar.MetricsExplorerToolbar, {
    derivedIndexPattern: derivedIndexPattern,
    timeRange: timeRange,
    options: options,
    chartOptions: chartOptions,
    onRefresh: refresh,
    onTimeChange: handleTimeChange,
    onGroupByChange: handleGroupByChange,
    onFilterQuerySubmit: handleFilterQuerySubmit,
    onMetricsChange: handleMetricsChange,
    onAggregationChange: handleAggregationChange,
    onChartOptionsChange: setChartOptions
  }), error ? /*#__PURE__*/_react.default.createElement(_empty_states.NoData, {
    titleText: "Whoops!",
    bodyText: _i18n.i18n.translate('xpack.infra.metricsExplorer.errorMessage', {
      defaultMessage: 'It looks like the request failed with "{message}"',
      values: {
        message: error.message
      }
    }),
    onRefetch: refresh,
    refetchText: "Try Again"
  }) : /*#__PURE__*/_react.default.createElement(_charts.MetricsExplorerCharts, {
    timeRange: timeRange,
    isLoading: isLoading,
    data: data,
    source: source,
    options: options,
    chartOptions: chartOptions,
    onLoadMore: handleLoadMore,
    onFilter: handleFilterQuerySubmit,
    onRefetch: refresh,
    onTimeChange: handleTimeChange
  })));
};
exports.MetricsExplorerPage = MetricsExplorerPage;