"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMetricsExplorerState = void 0;
var _datemath = _interopRequireDefault(require("@kbn/datemath"));
var _react = require("react");
var _use_metrics_explorer_data = require("./use_metrics_explorer_data");
var _use_metrics_explorer_options = require("./use_metrics_explorer_options");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useMetricsExplorerState = (source, derivedIndexPattern, enabled = true) => {
  const {
    defaultViewState,
    options,
    timeRange,
    chartOptions,
    setChartOptions,
    setTimeRange,
    setOptions,
    timestamps,
    setTimestamps
  } = (0, _use_metrics_explorer_options.useMetricsExplorerOptionsContainerContext)();
  const refreshTimestamps = (0, _react.useCallback)(() => {
    const fromTimestamp = _datemath.default.parse(timeRange.from).valueOf();
    const toTimestamp = _datemath.default.parse(timeRange.to, {
      roundUp: true
    }).valueOf();
    setTimestamps({
      interval: timeRange.interval,
      fromTimestamp,
      toTimestamp
    });
  }, [setTimestamps, timeRange]);
  const {
    data,
    error,
    fetchNextPage,
    isLoading
  } = (0, _use_metrics_explorer_data.useMetricsExplorerData)(options, source, derivedIndexPattern, timestamps, enabled);
  (0, _react.useEffect)(() => {
    refreshTimestamps();
    // options, setOptions are added to dependencies since we need to refresh the timestamps
    // every time options change
  }, [options, setOptions, refreshTimestamps]);
  const handleTimeChange = (0, _react.useCallback)((start, end) => {
    setTimeRange({
      interval: timeRange.interval,
      from: start,
      to: end
    });
  }, [setTimeRange, timeRange.interval]);
  const handleGroupByChange = (0, _react.useCallback)(groupBy => {
    setOptions({
      ...options,
      groupBy: groupBy || void 0
    });
  }, [options, setOptions]);
  const handleFilterQuerySubmit = (0, _react.useCallback)(query => {
    setOptions({
      ...options,
      filterQuery: query
    });
  }, [options, setOptions]);
  const handleMetricsChange = (0, _react.useCallback)(metrics => {
    setOptions({
      ...options,
      metrics
    });
  }, [options, setOptions]);
  const handleAggregationChange = (0, _react.useCallback)(aggregation => {
    const metrics = aggregation === 'count' ? [{
      aggregation
    }] : options.metrics.filter(metric => metric.aggregation !== 'count').map(metric => ({
      ...metric,
      aggregation
    }));
    setOptions({
      ...options,
      aggregation,
      metrics
    });
  }, [options, setOptions]);
  const onViewStateChange = (0, _react.useCallback)(vs => {
    if (vs.chartOptions) {
      setChartOptions(vs.chartOptions);
    }
    if (vs.currentTimerange) {
      // if this is the "Default View" view, don't update the time range to the view's time range,
      // this way it will use the global Kibana time or the default time already set
      if (vs.id !== '0') {
        setTimeRange(vs.currentTimerange);
      }
    }
    if (vs.options) {
      setOptions(vs.options);
    }
  }, [setChartOptions, setOptions, setTimeRange]);
  return {
    chartOptions,
    timeRange,
    data,
    defaultViewState,
    error,
    isLoading,
    handleAggregationChange,
    handleMetricsChange,
    handleFilterQuerySubmit,
    handleGroupByChange,
    handleTimeChange,
    handleLoadMore: fetchNextPage,
    onViewStateChange,
    options,
    setChartOptions,
    refresh: refreshTimestamps
  };
};
exports.useMetricsExplorerState = useMetricsExplorerState;