"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricsExplorerMetrics = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _color_palette = require("../../../../../common/color_palette");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MetricsExplorerMetrics = ({
  options,
  onChange,
  fields,
  autoFocus = false
}) => {
  const colors = Object.keys(_color_palette.Color);
  const [shouldFocus, setShouldFocus] = (0, _react.useState)(autoFocus);

  // the EuiCombobox forwards the ref to an input element
  const autoFocusInputElement = (0, _react.useCallback)(inputElement => {
    if (inputElement && shouldFocus) {
      inputElement.focus();
      setShouldFocus(false);
    }
  }, [shouldFocus]);
  const handleChange = (0, _react.useCallback)(selectedOptions => {
    onChange(selectedOptions.map((opt, index) => ({
      aggregation: options.aggregation,
      field: opt.value,
      color: colors[index]
    })));
  }, [onChange, options.aggregation, colors]);
  const comboOptions = fields.map(field => ({
    label: field.name,
    value: field.name
  }));
  const selectedOptions = options.metrics.filter(m => m.aggregation !== 'count').map(metric => ({
    label: metric.field || '',
    value: metric.field || '',
    color: (0, _color_palette.colorTransformer)(metric.color || _color_palette.Color.color0)
  }));
  const placeholderText = _i18n.i18n.translate('xpack.infra.metricsExplorer.metricComboBoxPlaceholder', {
    defaultMessage: 'choose a metric to plot'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    "data-test-subj": "metricsExplorer-metrics",
    "aria-label": placeholderText,
    isDisabled: options.aggregation === 'count',
    placeholder: placeholderText,
    fullWidth: true,
    options: comboOptions,
    selectedOptions: selectedOptions,
    onChange: handleChange,
    isClearable: true,
    inputRef: autoFocusInputElement
  });
};
exports.MetricsExplorerMetrics = MetricsExplorerMetrics;