"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricsExplorerAggregationPicker = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _metrics_explorer = require("../../../../../common/http_api/metrics_explorer");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MetricsExplorerAggregationPicker = ({
  options,
  onChange
}) => {
  const AGGREGATION_LABELS = {
    ['avg']: _i18n.i18n.translate('xpack.infra.metricsExplorer.aggregationLables.avg', {
      defaultMessage: 'Average'
    }),
    ['sum']: _i18n.i18n.translate('xpack.infra.metricsExplorer.aggregationLables.sum', {
      defaultMessage: 'Sum'
    }),
    ['max']: _i18n.i18n.translate('xpack.infra.metricsExplorer.aggregationLables.max', {
      defaultMessage: 'Max'
    }),
    ['min']: _i18n.i18n.translate('xpack.infra.metricsExplorer.aggregationLables.min', {
      defaultMessage: 'Min'
    }),
    ['cardinality']: _i18n.i18n.translate('xpack.infra.metricsExplorer.aggregationLables.cardinality', {
      defaultMessage: 'Cardinality'
    }),
    ['rate']: _i18n.i18n.translate('xpack.infra.metricsExplorer.aggregationLables.rate', {
      defaultMessage: 'Rate'
    }),
    ['p95']: _i18n.i18n.translate('xpack.infra.metricsExplorer.aggregationLables.p95', {
      defaultMessage: '95th Percentile'
    }),
    ['p99']: _i18n.i18n.translate('xpack.infra.metricsExplorer.aggregationLables.p99', {
      defaultMessage: '99th Percentile'
    }),
    ['count']: _i18n.i18n.translate('xpack.infra.metricsExplorer.aggregationLables.count', {
      defaultMessage: 'Document count'
    })
  };
  const handleChange = (0, _react.useCallback)(e => {
    const aggregation = _metrics_explorer.metricsExplorerAggregationRT.is(e.target.value) && e.target.value || 'avg';
    onChange(aggregation);
  }, [onChange]);
  const placeholder = _i18n.i18n.translate('xpack.infra.metricsExplorer.aggregationSelectLabel', {
    defaultMessage: 'Select an aggregation'
  });
  const METRIC_EXPLORER_AGGREGATIONS_WITHOUT_CUSTOM = (0, _lodash.xor)(_metrics_explorer.METRIC_EXPLORER_AGGREGATIONS, ['custom']);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    "data-test-subj": "infraMetricsExplorerAggregationPickerSelect",
    "aria-label": placeholder,
    placeholder: placeholder,
    fullWidth: true,
    value: options.aggregation,
    options: METRIC_EXPLORER_AGGREGATIONS_WITHOUT_CUSTOM.map(k => ({
      text: AGGREGATION_LABELS[k],
      value: k
    })),
    onChange: handleChange
  });
};
exports.MetricsExplorerAggregationPicker = MetricsExplorerAggregationPicker;