"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricDetail = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _common = require("@kbn/kibana-react-plugin/common");
var _public = require("@kbn/observability-plugin/public");
var _page_providers = require("./page_providers");
var _use_metadata = require("./hooks/use_metadata");
var _use_metrics_breadcrumbs = require("../../../hooks/use_metrics_breadcrumbs");
var _metrics_source = require("../../../containers/metrics_source");
var _loading = require("../../../components/loading");
var _inventory_models = require("../../../../common/inventory_models");
var _node_details_page = require("./components/node_details_page");
var _use_metrics_time = require("./hooks/use_metrics_time");
var _page_template = require("../page_template");
var _translations = require("../../../translations");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MetricDetail = (0, _page_providers.withMetricPageProviders)((0, _common.withTheme)(({
  match
}) => {
  const nodeId = match.params.node;
  const nodeType = match.params.type;
  const inventoryModel = (0, _inventory_models.findInventoryModel)(nodeType);
  const {
    sourceId,
    metricIndicesExist
  } = (0, _metrics_source.useSourceContext)();
  const {
    timeRange,
    parsedTimeRange,
    setTimeRange,
    refreshInterval,
    setRefreshInterval,
    isAutoReloading,
    setAutoReload,
    triggerRefresh
  } = (0, _use_metrics_time.useMetricsTimeContext)();
  const {
    name,
    filteredRequiredMetrics,
    loading: metadataLoading,
    cloudId,
    metadata
  } = (0, _use_metadata.useMetadata)(nodeId, nodeType, inventoryModel.requiredMetrics, sourceId, parsedTimeRange);
  const [sideNav, setSideNav] = (0, _react.useState)([]);
  const addNavItem = _react.default.useCallback(item => {
    if (!sideNav.some(n => n.id === item.id)) {
      setSideNav([item, ...sideNav]);
    }
  }, [sideNav]);
  const inventoryLinkProps = (0, _public.useLinkProps)({
    app: 'metrics',
    pathname: '/inventory'
  });
  (0, _use_metrics_breadcrumbs.useMetricsBreadcrumbs)([{
    ...inventoryLinkProps,
    text: _translations.inventoryTitle
  }, {
    text: name
  }]);
  if (metadataLoading && !filteredRequiredMetrics.length) {
    return /*#__PURE__*/_react.default.createElement(_page_template.MetricsPageTemplate, {
      hasData: metricIndicesExist
    }, /*#__PURE__*/_react.default.createElement(_loading.InfraLoadingPanel, {
      height: "100vh",
      width: "100%",
      text: _i18n.i18n.translate('xpack.infra.metrics.loadingNodeDataText', {
        defaultMessage: 'Loading data'
      })
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, metadata ? /*#__PURE__*/_react.default.createElement(_node_details_page.NodeDetailsPage, {
    name: name,
    requiredMetrics: filteredRequiredMetrics,
    sourceId: sourceId,
    timeRange: timeRange,
    nodeType: nodeType,
    nodeId: nodeId,
    cloudId: cloudId,
    metadataLoading: metadataLoading,
    isAutoReloading: isAutoReloading,
    refreshInterval: refreshInterval,
    sideNav: sideNav,
    metadata: metadata,
    addNavItem: addNavItem,
    setRefreshInterval: setRefreshInterval,
    setAutoReload: setAutoReload,
    triggerRefresh: triggerRefresh,
    setTimeRange: setTimeRange
  }) : null);
}));
exports.MetricDetail = MetricDetail;