"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMetadata = useMetadata;
var _react = require("react");
var _Either = require("fp-ts/lib/Either");
var _function = require("fp-ts/lib/function");
var _pipeable = require("fp-ts/lib/pipeable");
var _metadata_api = require("../../../../../common/http_api/metadata_api");
var _use_http_request = require("../../../../hooks/use_http_request");
var _runtime_types = require("../../../../../common/runtime_types");
var _get_filtered_metrics = require("../lib/get_filtered_metrics");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useMetadata(nodeId, nodeType, requiredMetrics, sourceId, timeRange) {
  const decodeResponse = response => {
    return (0, _pipeable.pipe)(_metadata_api.InfraMetadataRT.decode(response), (0, _Either.fold)((0, _runtime_types.throwErrors)(_runtime_types.createPlainError), _function.identity));
  };
  const {
    error,
    loading,
    response,
    makeRequest
  } = (0, _use_http_request.useHTTPRequest)('/api/infra/metadata', 'POST', JSON.stringify({
    nodeId,
    nodeType,
    sourceId,
    timeRange: {
      from: timeRange.from,
      to: timeRange.to
    }
  }), decodeResponse);
  (0, _react.useEffect)(() => {
    (async () => {
      await makeRequest();
    })();
  }, [makeRequest]);
  return {
    name: response && response.name || '',
    filteredRequiredMetrics: response && (0, _get_filtered_metrics.getFilteredMetrics)(requiredMetrics, response.features) || [],
    error: error && error.message || null,
    loading,
    metadata: response,
    cloudId: response && response.info && response.info.cloud && response.info.cloud.instance && response.info.cloud.instance.id || ''
  };
}