"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SnapshotPage = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/observability-plugin/public");
var _public2 = require("@kbn/core/public");
var _react2 = require("@emotion/react");
var _filter_bar = require("./components/filter_bar");
var _source_error_page = require("../../../components/source_error_page");
var _source_loading_page = require("../../../components/source_loading_page");
var _metrics_source = require("../../../containers/metrics_source");
var _use_metrics_breadcrumbs = require("../../../hooks/use_metrics_breadcrumbs");
var _layout_view = require("./components/layout_view");
var _saved_view = require("../../../containers/saved_view/saved_view");
var _use_waffle_view_state = require("./hooks/use_waffle_view_state");
var _use_waffle_options = require("./hooks/use_waffle_options");
var _page_template = require("../page_template");
var _translations = require("../../../translations");
var _saved_views = require("./components/saved_views");
var _snapshot_container = require("./components/snapshot_container");
var _page_template2 = require("../../../page_template.styles");
var _survey_kubernetes = require("./components/survey_kubernetes");
var _empty_states = require("../../../components/empty_states");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SnapshotPage = () => {
  var _source$status;
  const {
    isLoading,
    loadSourceFailureMessage,
    loadSource,
    source
  } = (0, _metrics_source.useSourceContext)();
  (0, _public.useTrackPageview)({
    app: 'infra_metrics',
    path: 'inventory'
  });
  (0, _public.useTrackPageview)({
    app: 'infra_metrics',
    path: 'inventory',
    delay: 15000
  });
  const {
    source: optionsSource
  } = (0, _use_waffle_options.useWaffleOptionsContext)();
  (0, _use_metrics_breadcrumbs.useMetricsBreadcrumbs)([{
    text: _translations.inventoryTitle
  }]);
  const {
    metricIndicesExist,
    remoteClustersExist
  } = (_source$status = source === null || source === void 0 ? void 0 : source.status) !== null && _source$status !== void 0 ? _source$status : {};
  if (isLoading && !source) return /*#__PURE__*/_react.default.createElement(_source_loading_page.SourceLoadingPage, null);
  if (!remoteClustersExist) {
    return /*#__PURE__*/_react.default.createElement(_empty_states.NoRemoteCluster, null);
  }
  if (!metricIndicesExist) {
    return /*#__PURE__*/_react.default.createElement(_page_template.MetricsPageTemplate, {
      hasData: metricIndicesExist,
      "data-test-subj": "noMetricsIndicesPrompt"
    });
  }
  if (loadSourceFailureMessage) return /*#__PURE__*/_react.default.createElement(_source_error_page.SourceErrorPage, {
    errorMessage: loadSourceFailureMessage || '',
    retry: loadSource
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiErrorBoundary, null, /*#__PURE__*/_react.default.createElement("div", {
    className: _public2.APP_WRAPPER_CLASS
  }, /*#__PURE__*/_react.default.createElement(_saved_view.SavedViewProvider, {
    shouldLoadDefault: optionsSource === 'default',
    viewType: 'inventory-view',
    defaultViewState: _use_waffle_view_state.DEFAULT_WAFFLE_VIEW_STATE
  }, /*#__PURE__*/_react.default.createElement(_page_template.MetricsPageTemplate, {
    hasData: metricIndicesExist,
    pageHeader: {
      pageTitle: _translations.inventoryTitle,
      rightSideItems: [/*#__PURE__*/_react.default.createElement(_saved_views.SavedViews, null), /*#__PURE__*/_react.default.createElement(_survey_kubernetes.SurveyKubernetes, null)]
    },
    pageSectionProps: {
      contentProps: {
        css: (0, _react2.css)`
                  ${_page_template2.fullHeightContentStyles};
                  padding-bottom: 0;
                `
      }
    }
  }, /*#__PURE__*/_react.default.createElement(_snapshot_container.SnapshotContainer, {
    render: ({
      loading,
      nodes,
      reload,
      interval
    }) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_filter_bar.FilterBar, {
      interval: interval
    }), /*#__PURE__*/_react.default.createElement(_layout_view.LayoutView, {
      loading: loading,
      nodes: nodes,
      reload: reload,
      interval: interval
    }))
  })))));
};
exports.SnapshotPage = SnapshotPage;