"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useWaffleViewState = exports.DEFAULT_WAFFLE_VIEW_STATE = void 0;
var _react = require("react");
var _use_waffle_options = require("./use_waffle_options");
var _use_waffle_time = require("./use_waffle_time");
var _use_waffle_filters = require("./use_waffle_filters");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_WAFFLE_VIEW_STATE = {
  ..._use_waffle_options.DEFAULT_WAFFLE_OPTIONS_STATE,
  filterQuery: _use_waffle_filters.DEFAULT_WAFFLE_FILTERS_STATE,
  time: _use_waffle_time.DEFAULT_WAFFLE_TIME_STATE.currentTime,
  autoReload: _use_waffle_time.DEFAULT_WAFFLE_TIME_STATE.isAutoReloading
};
exports.DEFAULT_WAFFLE_VIEW_STATE = DEFAULT_WAFFLE_VIEW_STATE;
const useWaffleViewState = () => {
  const {
    metric,
    groupBy,
    nodeType,
    view,
    customOptions,
    customMetrics,
    boundsOverride,
    autoBounds,
    accountId,
    region,
    legend,
    sort,
    timelineOpen,
    setWaffleOptionsState
  } = (0, _use_waffle_options.useWaffleOptionsContext)();
  const {
    currentTime,
    isAutoReloading,
    setWaffleTimeState
  } = (0, _use_waffle_time.useWaffleTimeContext)();
  const {
    filterQuery,
    setWaffleFiltersState
  } = (0, _use_waffle_filters.useWaffleFiltersContext)();
  const viewState = {
    metric,
    sort,
    groupBy,
    nodeType,
    view,
    customOptions,
    customMetrics,
    boundsOverride,
    autoBounds,
    accountId,
    region,
    time: currentTime,
    autoReload: isAutoReloading,
    filterQuery,
    legend,
    timelineOpen
  };
  const onViewChange = (0, _react.useCallback)(newState => {
    setWaffleOptionsState({
      sort: newState.sort,
      metric: newState.metric,
      groupBy: newState.groupBy,
      nodeType: newState.nodeType,
      view: newState.view,
      customOptions: newState.customOptions,
      customMetrics: newState.customMetrics,
      boundsOverride: newState.boundsOverride,
      autoBounds: newState.autoBounds,
      accountId: newState.accountId,
      region: newState.region,
      legend: newState.legend,
      timelineOpen: newState.timelineOpen
    });
    if (newState.time) {
      setWaffleTimeState({
        currentTime: newState.time,
        isAutoReloading: newState.autoReload
      });
    }
    setWaffleFiltersState(newState.filterQuery);
  }, [setWaffleOptionsState, setWaffleTimeState, setWaffleFiltersState]);
  return {
    viewState,
    defaultViewState: DEFAULT_WAFFLE_VIEW_STATE,
    onViewChange
  };
};
exports.useWaffleViewState = useWaffleViewState;