"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WaffleTimeControls = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireWildcard(require("react"));
var _common = require("@kbn/kibana-react-plugin/common");
var _convert_interval_to_string = require("../../../../../utils/convert_interval_to_string");
var _use_waffle_time = require("../../hooks/use_waffle_time");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const WaffleTimeControls = (0, _common.withTheme)(({
  interval
}) => {
  const {
    currentTime,
    isAutoReloading,
    startAutoReload,
    stopAutoReload,
    jumpToTime
  } = (0, _use_waffle_time.useWaffleTimeContext)();
  const currentMoment = (0, _moment.default)(currentTime);
  const intervalAsString = (0, _convert_interval_to_string.convertIntervalToString)(interval);
  const liveStreamingButton = isAutoReloading ? /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "infraWaffleTimeControlsStopRefreshingButton",
    color: "primary",
    iconSide: "left",
    iconType: "pause",
    onClick: stopAutoReload
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.waffleTime.stopRefreshingButtonLabel",
    defaultMessage: "Stop refreshing"
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "infraWaffleTimeControlsAutoRefreshButton",
    iconSide: "left",
    iconType: "play",
    onClick: startAutoReload
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.waffleTime.autoRefreshButtonLabel",
    defaultMessage: "Auto-refresh"
  }));
  const handleChangeDate = (0, _react.useCallback)(time => {
    if (time) {
      jumpToTime(time.valueOf());
    }
  }, [jumpToTime]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": "waffleDatePicker"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: `Last ${intervalAsString} of data for the selected time`,
    delay: "long",
    display: "inlineBlock",
    position: "top",
    "data-test-subj": "waffleDatePickerIntervalTooltip"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDatePicker, {
    dateFormat: "L LTS",
    disabled: isAutoReloading,
    injectTimes: currentMoment ? [currentMoment] : [],
    isLoading: isAutoReloading,
    onChange: handleChangeDate,
    popoverPlacement: "upRight",
    selected: currentMoment,
    shouldCloseOnSelect: true,
    showTimeSelect: true,
    timeFormat: "LT"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, liveStreamingButton));
});
exports.WaffleTimeControls = WaffleTimeControls;