"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepLegend = void 0;
var _polished = require("polished");
var _react = _interopRequireDefault(require("react"));
var _common = require("@kbn/kibana-react-plugin/common");
var _lib = require("../../../../../lib/lib");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OPERATORS = {
  [_lib.InfraWaffleMapRuleOperator.gte]: '>=',
  [_lib.InfraWaffleMapRuleOperator.gt]: '>',
  [_lib.InfraWaffleMapRuleOperator.lte]: '<=',
  [_lib.InfraWaffleMapRuleOperator.lt]: '<',
  [_lib.InfraWaffleMapRuleOperator.eq]: '='
};
const createStep = formatter => (rule, index) => {
  const label = rule.label != null ? rule.label : `${OPERATORS[rule.operator]} ${formatter(rule.value)}`;
  const squareStyle = {
    backgroundColor: (0, _polished.darken)(0.4, rule.color)
  };
  const squareInnerStyle = {
    backgroundColor: rule.color
  };
  return /*#__PURE__*/_react.default.createElement(StepContainer, {
    key: `legend-step-${index}`
  }, /*#__PURE__*/_react.default.createElement(StepSquare, {
    style: squareStyle
  }, /*#__PURE__*/_react.default.createElement(StepSquareInner, {
    style: squareInnerStyle
  })), /*#__PURE__*/_react.default.createElement(StepLabel, null, label));
};
const StepLegend = ({
  legend,
  formatter
}) => {
  return /*#__PURE__*/_react.default.createElement(StepLegendContainer, null, legend.rules.map(createStep(formatter)));
};
exports.StepLegend = StepLegend;
const StepLegendContainer = _common.euiStyled.div`
  display: flex;
  padding: 10px 40px 10px 10px;
`;
const StepContainer = _common.euiStyled.div`
  display: flex;
  margin-right: 20px
  align-items: center;
`;
const StepSquare = _common.euiStyled.div`
  position: relative;
  width: 24px;
  height: 24px;
  flex: 0 0 auto;
  margin-right: 5px;
  border-radius: 3px;
  box-shadow: 0 1px 2px 0 rgba(0, 0, 0, 0.2);
`;
const StepSquareInner = _common.euiStyled.div`
  position: absolute;
  top: 0;
  left: 0;
  right: 0;
  bottom: 2px;
  border-radius: 3px;
`;
const StepLabel = _common.euiStyled.div`
  font-size: 12px;
`;