"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NodeContextMenu = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _common = require("@kbn/kibana-react-plugin/common");
var _public2 = require("@kbn/observability-plugin/public");
var _alert_flyout = require("../../../../../alerting/inventory/components/alert_flyout");
var _link_to = require("../../../../link_to");
var _inventory_models = require("../../../../../../common/inventory_models");
var _navigate_to_uptime = require("../../lib/navigate_to_uptime");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NodeContextMenu = (0, _common.withTheme)(({
  options,
  currentTime,
  node,
  nodeType
}) => {
  var _uiCapabilities$logs, _uiCapabilities$infra;
  const [flyoutVisible, setFlyoutVisible] = (0, _react.useState)(false);
  const inventoryModel = (0, _inventory_models.findInventoryModel)(nodeType);
  const nodeDetailFrom = currentTime - inventoryModel.metrics.defaultTimeRangeInSeconds * 1000;
  const {
    application,
    share
  } = (0, _public.useKibana)().services;
  const uiCapabilities = application === null || application === void 0 ? void 0 : application.capabilities;
  // Due to the changing nature of the fields between APM and this UI,
  // We need to have some exceptions until 7.0 & ECS is finalized. Reference
  // #26620 for the details for these fields.
  // TODO: This is tech debt, remove it after 7.0 & ECS migration.
  const apmField = nodeType === 'host' ? 'host.hostname' : inventoryModel.fields.id;
  const showDetail = inventoryModel.crosslinkSupport.details;
  const showLogsLink = inventoryModel.crosslinkSupport.logs && node.id && (uiCapabilities === null || uiCapabilities === void 0 ? void 0 : (_uiCapabilities$logs = uiCapabilities.logs) === null || _uiCapabilities$logs === void 0 ? void 0 : _uiCapabilities$logs.show);
  const showAPMTraceLink = inventoryModel.crosslinkSupport.apm && (uiCapabilities === null || uiCapabilities === void 0 ? void 0 : uiCapabilities.apm) && (uiCapabilities === null || uiCapabilities === void 0 ? void 0 : uiCapabilities.apm.show);
  const showUptimeLink = inventoryModel.crosslinkSupport.uptime && (['pod', 'container'].includes(nodeType) || node.ip);
  const showCreateAlertLink = uiCapabilities === null || uiCapabilities === void 0 ? void 0 : (_uiCapabilities$infra = uiCapabilities.infrastructure) === null || _uiCapabilities$infra === void 0 ? void 0 : _uiCapabilities$infra.save;
  const inventoryId = (0, _react.useMemo)(() => {
    if (nodeType === 'host') {
      if (node.ip) {
        return {
          label: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "host.ip"),
          value: node.ip
        };
      }
    } else {
      const {
        id
      } = (0, _inventory_models.findInventoryFields)(nodeType);
      return {
        label: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, id),
        value: node.id
      };
    }
    return {
      label: '',
      value: ''
    };
  }, [nodeType, node.ip, node.id]);
  const nodeLogsMenuItemLinkProps = (0, _public2.useLinkProps)((0, _link_to.getNodeLogsUrl)({
    nodeType,
    nodeId: node.id,
    time: currentTime
  }));
  const nodeDetailMenuItemLinkProps = (0, _public2.useLinkProps)({
    ...(0, _link_to.getNodeDetailUrl)({
      nodeType,
      nodeId: node.id,
      from: nodeDetailFrom,
      to: currentTime
    })
  });
  const apmTracesMenuItemLinkProps = (0, _public2.useLinkProps)({
    app: 'apm',
    hash: 'traces',
    search: {
      kuery: `${apmField}:"${node.id}"`
    }
  });
  const nodeLogsMenuItem = {
    label: _i18n.i18n.translate('xpack.infra.nodeContextMenu.viewLogsName', {
      defaultMessage: '{inventoryName} logs',
      values: {
        inventoryName: inventoryModel.singularDisplayName
      }
    }),
    ...nodeLogsMenuItemLinkProps,
    'data-test-subj': 'viewLogsContextMenuItem',
    isDisabled: !showLogsLink
  };
  const nodeDetailMenuItem = {
    label: _i18n.i18n.translate('xpack.infra.nodeContextMenu.viewMetricsName', {
      defaultMessage: '{inventoryName} metrics',
      values: {
        inventoryName: inventoryModel.singularDisplayName
      }
    }),
    ...nodeDetailMenuItemLinkProps,
    isDisabled: !showDetail
  };
  const apmTracesMenuItem = {
    label: _i18n.i18n.translate('xpack.infra.nodeContextMenu.viewAPMTraces', {
      defaultMessage: '{inventoryName} APM traces',
      values: {
        inventoryName: inventoryModel.singularDisplayName
      }
    }),
    ...apmTracesMenuItemLinkProps,
    'data-test-subj': 'viewApmTracesContextMenuItem',
    isDisabled: !showAPMTraceLink
  };
  const uptimeMenuItem = {
    label: _i18n.i18n.translate('xpack.infra.nodeContextMenu.viewUptimeLink', {
      defaultMessage: '{inventoryName} in Uptime',
      values: {
        inventoryName: inventoryModel.singularDisplayName
      }
    }),
    onClick: () => (0, _navigate_to_uptime.navigateToUptime)(share.url.locators, nodeType, node),
    isDisabled: !showUptimeLink
  };
  const createAlertMenuItem = {
    label: _i18n.i18n.translate('xpack.infra.nodeContextMenu.createRuleLink', {
      defaultMessage: 'Create inventory rule'
    }),
    onClick: () => {
      setFlyoutVisible(true);
    },
    isDisabled: !showCreateAlertLink
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      maxWidth: 300
    },
    "data-test-subj": "nodeContextMenu"
  }, /*#__PURE__*/_react.default.createElement(_public2.Section, null, /*#__PURE__*/_react.default.createElement(_public2.SectionTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.nodeContextMenu.title",
    defaultMessage: "{inventoryName} details",
    values: {
      inventoryName: inventoryModel.singularDisplayName
    }
  })), inventoryId.label && /*#__PURE__*/_react.default.createElement(_public2.SectionSubtitle, null, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      wordBreak: 'break-all'
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.nodeContextMenu.description",
    defaultMessage: "View details for {label} {value}",
    values: {
      label: inventoryId.label,
      value: inventoryId.value
    }
  }))), /*#__PURE__*/_react.default.createElement(_public2.SectionLinks, null, /*#__PURE__*/_react.default.createElement(_public2.SectionLink, (0, _extends2.default)({
    "data-test-subj": "viewLogsContextMenuItem"
  }, nodeLogsMenuItem)), /*#__PURE__*/_react.default.createElement(_public2.SectionLink, nodeDetailMenuItem), /*#__PURE__*/_react.default.createElement(_public2.SectionLink, (0, _extends2.default)({
    "data-test-subj": "viewApmTracesContextMenuItem"
  }, apmTracesMenuItem)), /*#__PURE__*/_react.default.createElement(_public2.SectionLink, (0, _extends2.default)({}, uptimeMenuItem, {
    color: 'primary'
  }))), /*#__PURE__*/_react.default.createElement(_public2.ActionMenuDivider, null), /*#__PURE__*/_react.default.createElement(_public2.SectionLinks, null, /*#__PURE__*/_react.default.createElement(_public2.SectionLink, (0, _extends2.default)({
    iconType: 'bell',
    color: 'primary'
  }, createAlertMenuItem))))), flyoutVisible && /*#__PURE__*/_react.default.createElement(_alert_flyout.AlertFlyout, {
    filter: `${(0, _inventory_models.findInventoryFields)(nodeType).id}: "${node.id}"`,
    options: options,
    nodeType: nodeType,
    setVisible: setFlyoutVisible,
    visible: flyoutVisible
  }));
});
exports.NodeContextMenu = NodeContextMenu;