"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GroupName = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _common = require("@kbn/kibana-react-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class GroupName extends _react.default.PureComponent {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "handleClick", event => {
      event.preventDefault();
      const {
        groupBy
      } = this.props.options;
      // When groupBy is empty that means there is nothing todo so let's just do nothing.
      if (groupBy.length === 0) {
        return;
      }
      const currentPath = this.props.isChild && groupBy.length > 1 ? groupBy[1] : groupBy[0];
      this.props.onDrilldown(`${currentPath.field}: "${this.props.group.name}"`);
    });
  }
  render() {
    const {
      group,
      isChild
    } = this.props;
    const linkStyle = {
      fontSize: isChild ? '0.85em' : '1em'
    };
    return /*#__PURE__*/_react.default.createElement(GroupNameContainer, null, /*#__PURE__*/_react.default.createElement(Inner, {
      isChild: isChild
    }, /*#__PURE__*/_react.default.createElement(Name, null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: group.name
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      style: linkStyle,
      onClickCapture: this.handleClick,
      "data-test-subj": "groupNameLink"
    }, group.name))), /*#__PURE__*/_react.default.createElement(Count, null, group.count)));
  }
}
exports.GroupName = GroupName;
const GroupNameContainer = _common.euiStyled.div`
  position: relative;
  text-align: center;
  font-size: 16px;
  margin-bottom: 5px;
  top: 20px;
  display: flex;
  justify-content: center;
  padding: 0 10px;
`;
const Inner = _common.euiStyled.div`
  border: 1px solid ${props => props.theme.eui.euiBorderColor};
  background-color: ${props => props.isChild ? props.theme.eui.euiColorLightestShade : props.theme.eui.euiColorEmptyShade};
  border-radius: 4px;
  box-shadow: 0px 2px 0px 0px ${props => props.theme.eui.euiBorderColor};
  display: flex;
  align-items: center;
  justify-content: center;
  overflow: hidden;
`;
const Name = _common.euiStyled.div`
  flex: 1 1 auto;
  padding: 6px 10px;
  overflow: hidden;
  text-overflow: ellipsis;
  white-space: nowrap;
`;
const Count = _common.euiStyled.div`
  flex: 0 0 auto;
  border-left: 1px solid ${props => props.theme.eui.euiBorderColor};
  padding: 6px 10px;
  font-size: 0.85em;
  font-weight: normal;
`;