"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomFieldPanel = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initialState = {
  selectedOptions: []
};
class CustomFieldPanel extends _react.default.PureComponent {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", initialState);
    (0, _defineProperty2.default)(this, "handleSubmit", () => {
      this.props.onSubmit(this.state.selectedOptions[0].label);
    });
    (0, _defineProperty2.default)(this, "handleFieldSelection", selectedOptions => {
      this.setState({
        selectedOptions
      });
    });
  }
  render() {
    const {
      fields,
      currentOptions
    } = this.props;
    const options = fields.filter(f => f.aggregatable && f.type === 'string' && !(currentOptions && currentOptions.some(o => o.field === f.name))).map(f => ({
      label: f.name
    }));
    const isSubmitDisabled = !this.state.selectedOptions.length;
    return /*#__PURE__*/_react.default.createElement("div", {
      style: {
        padding: 16
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.infra.waffle.customGroupByFieldLabel', {
        defaultMessage: 'Field'
      }),
      helpText: _i18n.i18n.translate('xpack.infra.waffle.customGroupByHelpText', {
        defaultMessage: 'This is the field used for the terms aggregation'
      }),
      display: "rowCompressed",
      fullWidth: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
      "data-test-subj": "groupByCustomField",
      placeholder: _i18n.i18n.translate('xpack.infra.waffle.customGroupByDropdownPlacehoder', {
        defaultMessage: 'Select one'
      }),
      singleSelection: {
        asPlainText: true
      },
      selectedOptions: this.state.selectedOptions,
      options: options,
      onChange: this.handleFieldSelection,
      fullWidth: true,
      isClearable: false
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "groupByCustomFieldAddButton",
      disabled: isSubmitDisabled,
      type: "submit",
      size: "s",
      fill: true,
      onClick: this.handleSubmit
    }, "Add")));
  }
}
exports.CustomFieldPanel = CustomFieldPanel;
(0, _defineProperty2.default)(CustomFieldPanel, "displayName", 'CustomFieldPanel');