"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Timeline = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _moment = _interopRequireDefault(require("moment"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _charts = require("@elastic/charts");
var _public = require("@kbn/kibana-react-plugin/public");
var _common = require("@kbn/kibana-react-plugin/common");
var _snapshot_metric_i18n = require("../../../../../../common/snapshot_metric_i18n");
var _color_palette = require("../../../../../../common/color_palette");
var _metrics_source = require("../../../../../containers/metrics_source");
var _use_timeline = require("../../hooks/use_timeline");
var _use_waffle_options = require("../../hooks/use_waffle_options");
var _use_waffle_time = require("../../hooks/use_waffle_time");
var _use_waffle_filters = require("../../hooks/use_waffle_filters");
var _series_chart = require("../../../metrics_explorer/components/series_chart");
var _use_metrics_explorer_options = require("../../../metrics_explorer/hooks/use_metrics_explorer_options");
var _get_chart_theme = require("../../../../../utils/get_chart_theme");
var _calculate_domain = require("../../../metrics_explorer/components/helpers/calculate_domain");
var _use_metrics_hosts_anomalies = require("../../hooks/use_metrics_hosts_anomalies");
var _use_metrics_k8s_anomalies = require("../../hooks/use_metrics_k8s_anomalies");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Timeline = ({
  interval,
  yAxisFormatter,
  isVisible
}) => {
  var _toMetricOpt, _toMetricOpt2;
  const {
    sourceId,
    source
  } = (0, _metrics_source.useSourceContext)();
  const {
    metric,
    nodeType,
    accountId,
    region
  } = (0, _use_waffle_options.useWaffleOptionsContext)();
  const {
    currentTime,
    jumpToTime,
    stopAutoReload
  } = (0, _use_waffle_time.useWaffleTimeContext)();
  const {
    filterQueryAsJson
  } = (0, _use_waffle_filters.useWaffleFiltersContext)();
  const {
    loading,
    error,
    startTime,
    endTime,
    timeseries,
    reload
  } = (0, _use_timeline.useTimeline)(filterQueryAsJson, [metric], nodeType, sourceId, currentTime, accountId, region, interval, isVisible);
  const anomalyParams = {
    sourceId: 'default',
    anomalyThreshold: (source === null || source === void 0 ? void 0 : source.configuration.anomalyThreshold) || 0,
    startTime,
    endTime,
    defaultSortOptions: {
      direction: 'desc',
      field: 'anomalyScore'
    },
    defaultPaginationOptions: {
      pageSize: 100
    }
  };
  const {
    metricsHostsAnomalies,
    getMetricsHostsAnomalies
  } = (0, _use_metrics_hosts_anomalies.useMetricsHostsAnomaliesResults)(anomalyParams);
  const {
    metricsK8sAnomalies,
    getMetricsK8sAnomalies
  } = (0, _use_metrics_k8s_anomalies.useMetricsK8sAnomaliesResults)(anomalyParams);
  const getAnomalies = (0, _react.useMemo)(() => {
    if (nodeType === 'host') {
      return getMetricsHostsAnomalies;
    } else if (nodeType === 'pod') {
      return getMetricsK8sAnomalies;
    }
  }, [nodeType, getMetricsK8sAnomalies, getMetricsHostsAnomalies]);
  const anomalies = (0, _react.useMemo)(() => {
    if (nodeType === 'host') {
      return metricsHostsAnomalies;
    } else if (nodeType === 'pod') {
      return metricsK8sAnomalies;
    }
  }, [nodeType, metricsHostsAnomalies, metricsK8sAnomalies]);
  const metricLabel = (_toMetricOpt = (0, _snapshot_metric_i18n.toMetricOpt)(metric.type)) === null || _toMetricOpt === void 0 ? void 0 : _toMetricOpt.textLC;
  const metricPopoverLabel = (_toMetricOpt2 = (0, _snapshot_metric_i18n.toMetricOpt)(metric.type)) === null || _toMetricOpt2 === void 0 ? void 0 : _toMetricOpt2.text;
  const chartMetric = {
    color: _color_palette.Color.color0,
    aggregation: 'avg',
    label: metricPopoverLabel
  };
  const dateFormatter = (0, _react.useMemo)(() => {
    var _first, _last;
    if (!timeseries) return () => '';
    const firstTimestamp = (_first = (0, _lodash.first)(timeseries.rows)) === null || _first === void 0 ? void 0 : _first.timestamp;
    const lastTimestamp = (_last = (0, _lodash.last)(timeseries.rows)) === null || _last === void 0 ? void 0 : _last.timestamp;
    if (firstTimestamp == null || lastTimestamp == null) {
      return value => `${value}`;
    }
    return (0, _charts.niceTimeFormatter)([firstTimestamp, lastTimestamp]);
  }, [timeseries]);
  const isDarkMode = (0, _public.useUiSetting)('theme:darkMode');
  const tooltipProps = {
    headerFormatter: tooltipValue => (0, _moment.default)(tooltipValue.value).format('Y-MM-DD HH:mm:ss.SSS')
  };
  const dataDomain = timeseries ? (0, _calculate_domain.calculateDomain)(timeseries, [chartMetric], false) : null;
  const domain = dataDomain ? {
    max: dataDomain.max * 1.1,
    // add 10% headroom.
    min: dataDomain.min
  } : {
    max: 0,
    min: 0
  };
  const onClickPoint = (0, _react.useCallback)(([elementEvent]) => {
    // casting to GeometryValue as we are using cartesian charts
    const [geometryValue] = elementEvent;
    if (geometryValue && !Array.isArray(geometryValue)) {
      const {
        x: timestamp
      } = geometryValue;
      jumpToTime(timestamp);
      stopAutoReload();
    }
  }, [jumpToTime, stopAutoReload]);
  const anomalyMetricName = (0, _react.useMemo)(() => {
    const metricType = metric.type;
    if (metricType === 'memory') {
      return 'memory_usage';
    }
    if (metricType === 'rx') {
      return 'network_in';
    }
    if (metricType === 'tx') {
      return 'network_out';
    }
  }, [metric]);
  (0, _react.useEffect)(() => {
    if (getAnomalies && anomalyMetricName) {
      getAnomalies(anomalyMetricName);
    }
  }, [getAnomalies, anomalyMetricName]);
  if (loading) {
    return /*#__PURE__*/_react.default.createElement(TimelineContainer, null, /*#__PURE__*/_react.default.createElement(TimelineLoadingContainer, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, {
      size: "xl"
    })));
  }
  if (!loading && (error || !timeseries)) {
    return /*#__PURE__*/_react.default.createElement(TimelineContainer, null, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      iconType: "visArea",
      title: /*#__PURE__*/_react.default.createElement("h4", null, error ? errorTitle : noHistoryDataTitle),
      actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        "data-test-subj": "infraTimelineButton",
        color: "primary",
        fill: true,
        onClick: reload
      }, error ? retryButtonLabel : checkNewDataButtonLabel)
    }));
  }
  function generateAnnotationData(results) {
    return results.map(anomaly => {
      const [val, influencers] = anomaly;
      return {
        coordinates: {
          x0: val,
          x1: (0, _moment.default)(val).add(15, 'minutes').valueOf(),
          y0: dataDomain === null || dataDomain === void 0 ? void 0 : dataDomain.min,
          y1: dataDomain === null || dataDomain === void 0 ? void 0 : dataDomain.max
        },
        details: influencers.join(',')
      };
    });
  }
  return /*#__PURE__*/_react.default.createElement(TimelineContainer, {
    "data-test-subj": isVisible ? 'timelineContainerOpen' : 'timelineContainerClosed'
  }, /*#__PURE__*/_react.default.createElement(TimelineHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.inventoryTimeline.header",
    defaultMessage: "Average {metricLabel}",
    values: {
      metricLabel
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: 'center',
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: 's',
    alignItems: 'center',
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    color: (0, _color_palette.colorTransformer)(chartMetric.color),
    type: 'dot'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: 'xs'
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.inventoryTimeline.header",
    defaultMessage: "Average {metricLabel}",
    values: {
      metricLabel
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: 's',
    alignItems: 'center',
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      backgroundColor: '#D36086',
      height: 5,
      width: 10
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: 'xs'
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.inventoryTimeline.legend.anomalyLabel",
    defaultMessage: "Anomaly detected"
  })))))))), /*#__PURE__*/_react.default.createElement(TimelineChartContainer, null, /*#__PURE__*/_react.default.createElement(_charts.Chart, null, anomalies && /*#__PURE__*/_react.default.createElement(_charts.RectAnnotation, {
    id: 'anomalies',
    dataValues: generateAnnotationData(anomalies.map(a => [a.startTime, a.influencers])),
    style: {
      fill: '#D36086'
    }
  }), /*#__PURE__*/_react.default.createElement(_series_chart.MetricExplorerSeriesChart, {
    type: _use_metrics_explorer_options.MetricsExplorerChartType.area,
    metric: chartMetric,
    id: "0",
    series: timeseries,
    stack: false
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: 'timestamp',
    position: _charts.Position.Bottom,
    showOverlappingTicks: true,
    tickFormat: dateFormatter
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: 'values',
    position: _charts.Position.Left,
    tickFormat: yAxisFormatter,
    domain: domain,
    ticks: 6,
    showGridLines: true
  }), /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    tooltip: tooltipProps,
    theme: (0, _get_chart_theme.getTimelineChartTheme)(isDarkMode),
    onElementClick: onClickPoint
  }))));
};
exports.Timeline = Timeline;
const TimelineContainer = _common.euiStyled.div`
  background-color: ${props => props.theme.eui.euiPageBackgroundColor};
  border-top: 1px solid ${props => props.theme.eui.euiColorLightShade};
  height: 220px;
  width: 100%;
  padding: ${props => props.theme.eui.euiSizeS} ${props => props.theme.eui.euiSizeM};
  display: flex;
  flex-direction: column;
`;
const TimelineHeader = _common.euiStyled.div`
  display: flex;
  width: 100%;
  padding: ${props => props.theme.eui.euiSizeS} ${props => props.theme.eui.euiSizeM};
  @media only screen and (max-width: 767px) {
      margin-top: 30px;
  }
`;
const TimelineChartContainer = _common.euiStyled.div`
  padding-left: ${props => props.theme.eui.euiSizeXS};
  width: 100%;
  height: 100%;
`;
const TimelineLoadingContainer = _common.euiStyled.div`
  display: flex;
  justify-content: center;
  align-items: center;
  height: 100%;
`;
const noHistoryDataTitle = _i18n.i18n.translate('xpack.infra.inventoryTimeline.noHistoryDataTitle', {
  defaultMessage: 'There is no historical data to display.'
});
const errorTitle = _i18n.i18n.translate('xpack.infra.inventoryTimeline.errorTitle', {
  defaultMessage: 'Unable to show historical data.'
});
const checkNewDataButtonLabel = _i18n.i18n.translate('xpack.infra.inventoryTimeline.checkNewDataButtonLabel', {
  defaultMessage: 'Check for new data'
});
const retryButtonLabel = _i18n.i18n.translate('xpack.infra.inventoryTimeline.retryButtonLabel', {
  defaultMessage: 'Try again'
});