"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SurveyKubernetes = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _useLocalStorage = _interopRequireDefault(require("react-use/lib/useLocalStorage"));
var _use_waffle_options = require("../hooks/use_waffle_options");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const KUBERNETES_TOAST_STORAGE_KEY = 'kubernetesToastKey';
const KUBERNETES_FEEDBACK_LINK = 'https://ela.st/k8s-feedback';
const SurveyKubernetes = () => {
  const {
    nodeType
  } = (0, _use_waffle_options.useWaffleOptionsContext)();
  const podNodeType = 'pod';
  const [isToastSeen, setIsToastSeen] = (0, _useLocalStorage.default)(KUBERNETES_TOAST_STORAGE_KEY, false);
  const markToastAsSeen = () => setIsToastSeen(true);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, nodeType === podNodeType && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    href: KUBERNETES_FEEDBACK_LINK,
    target: "_blank",
    color: "warning",
    iconType: "editorComment",
    "data-test-subj": "infra-kubernetes-feedback-link"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.homePage.tellUsWhatYouThinkK8sLink",
    defaultMessage: "Tell us what you think! (K8s)"
  })), !isToastSeen && /*#__PURE__*/_react.default.createElement(_eui.EuiGlobalToastList, {
    toastLifeTimeMs: Infinity,
    dismissToast: markToastAsSeen,
    toasts: [{
      id: 'k8s-toast',
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.infra.homePage.kubernetesToastTitle",
        defaultMessage: "We need your help!"
      }),
      color: 'primary',
      iconType: 'help',
      toastLifeTimeMs: 0x7fffffff,
      // Biggest possible lifetime because we control when it should be visible using isToastSeen
      text: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.infra.homePage.kubernetesToastText",
        defaultMessage: "Help us design your Kubernetes experience by completing a feedback survey."
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        justifyContent: "flexEnd",
        gutterSize: "s"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        "data-test-subj": "infra-toast-kubernetes-survey-start",
        href: KUBERNETES_FEEDBACK_LINK,
        target: "_blank",
        onClickCapture: markToastAsSeen,
        size: "s"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.infra.homePage.kubernetesToastButton",
        defaultMessage: "Start survey"
      })))))
    }]
  })));
};
exports.SurveyKubernetes = SurveyKubernetes;