"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Table = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _useToggle = _interopRequireDefault(require("react-use/lib/useToggle"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Table = props => {
  const {
    rows,
    title,
    onClick
  } = props;
  const columns = (0, _react.useMemo)(() => [{
    field: 'name',
    name: '',
    width: '35%',
    sortable: false,
    render: (name, item) => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("strong", null, item.name))
  }, {
    field: 'value',
    name: '',
    width: '65%',
    sortable: false,
    render: (_name, item) => {
      return /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: 'xs',
        alignItems: 'center',
        responsive: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: _i18n.i18n.translate('xpack.infra.nodeDetails.tabs.metadata.setFilterTooltip', {
          defaultMessage: 'View event with filter'
        })
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        color: "text",
        size: "s",
        iconType: "filter",
        "aria-label": _i18n.i18n.translate('xpack.infra.nodeDetails.tabs.metadata.filterAriaLabel', {
          defaultMessage: 'Filter'
        }),
        onClick: () => onClick(item)
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(ExpandableContent, {
        values: item.value
      }))));
    }
  }], [onClick]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h4", null, title)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 's'
  }), /*#__PURE__*/_react.default.createElement(TableWithoutHeader, {
    tableLayout: 'fixed',
    compressed: true,
    responsive: false,
    columns: columns,
    items: rows
  }));
};
exports.Table = Table;
class TableWithoutHeader extends _eui.EuiBasicTable {
  renderTableHead() {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  }
}
const ExpandableContent = props => {
  const {
    values
  } = props;
  const [isExpanded, toggle] = (0, _useToggle.default)(false);
  const list = Array.isArray(values) ? values : [values];
  const [first, ...others] = list;
  const hasOthers = others.length > 0;
  const shouldShowMore = hasOthers && !isExpanded;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: 'xs',
    responsive: false,
    alignItems: 'baseline',
    wrap: true,
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement("div", null, first, shouldShowMore && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, ' ... ', /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "infraArrayValueCountMoreLink",
    onClick: toggle
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.nodeDetails.tabs.metadata.seeMore",
    defaultMessage: "+{count} more",
    values: {
      count: others.length
    }
  })))), isExpanded && others.map(item => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: item
  }, item)), hasOthers && isExpanded && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "infraArrayValueShowLessLink",
    onClick: toggle
  }, _i18n.i18n.translate('xpack.infra.nodeDetails.tabs.metadata.seeLess', {
    defaultMessage: 'Show less'
  }))));
};