"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PropertiesTab = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _common = require("@kbn/kibana-react-plugin/common");
var _shared = require("../shared");
var _metrics_source = require("../../../../../../../containers/metrics_source");
var _inventory_models = require("../../../../../../../../common/inventory_models");
var _use_metadata = require("../../../../../metric_detail/hooks/use_metadata");
var _build_fields = require("./build_fields");
var _use_waffle_time = require("../../../../hooks/use_waffle_time");
var _table = require("./table");
var _use_waffle_filters = require("../../../../hooks/use_waffle_filters");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TabComponent = props => {
  const nodeId = props.node.id;
  const nodeType = props.nodeType;
  const inventoryModel = (0, _inventory_models.findInventoryModel)(nodeType);
  const {
    sourceId
  } = (0, _metrics_source.useSourceContext)();
  const {
    currentTimeRange
  } = (0, _use_waffle_time.useWaffleTimeContext)();
  const {
    applyFilterQuery
  } = (0, _use_waffle_filters.useWaffleFiltersContext)();
  const {
    loading: metadataLoading,
    metadata
  } = (0, _use_metadata.useMetadata)(nodeId, nodeType, inventoryModel.requiredMetrics, sourceId, currentTimeRange);
  const hostFields = (0, _react.useMemo)(() => {
    if (!metadata) return null;
    return (0, _build_fields.getFields)(metadata, 'host');
  }, [metadata]);
  const cloudFields = (0, _react.useMemo)(() => {
    if (!metadata) return null;
    return (0, _build_fields.getFields)(metadata, 'cloud');
  }, [metadata]);
  const agentFields = (0, _react.useMemo)(() => {
    if (!metadata) return null;
    return (0, _build_fields.getFields)(metadata, 'agent');
  }, [metadata]);
  const onFilter = (0, _react.useCallback)(item => {
    applyFilterQuery({
      kind: 'kuery',
      expression: `${item.name}: "${item.value}"`
    });
  }, [applyFilterQuery]);
  if (metadataLoading) {
    return /*#__PURE__*/_react.default.createElement(LoadingPlaceholder, null);
  }
  return /*#__PURE__*/_react.default.createElement(_shared.TabContent, null, hostFields && hostFields.length > 0 && /*#__PURE__*/_react.default.createElement(TableWrapper, null, /*#__PURE__*/_react.default.createElement(_table.Table, {
    title: _i18n.i18n.translate('xpack.infra.nodeDetails.tabs.metadata.hostsHeader', {
      defaultMessage: 'Hosts'
    }),
    onClick: onFilter,
    rows: hostFields
  })), cloudFields && cloudFields.length > 0 && /*#__PURE__*/_react.default.createElement(TableWrapper, null, /*#__PURE__*/_react.default.createElement(_table.Table, {
    title: _i18n.i18n.translate('xpack.infra.nodeDetails.tabs.metadata.cloudHeader', {
      defaultMessage: 'Cloud'
    }),
    onClick: onFilter,
    rows: cloudFields
  })), agentFields && agentFields.length > 0 && /*#__PURE__*/_react.default.createElement(TableWrapper, null, /*#__PURE__*/_react.default.createElement(_table.Table, {
    title: _i18n.i18n.translate('xpack.infra.nodeDetails.tabs.metadata.agentHeader', {
      defaultMessage: 'Agent'
    }),
    onClick: onFilter,
    rows: agentFields
  })));
};
const TableWrapper = _common.euiStyled.div`
  &:not(:last-child) {
    margin-bottom: 16px
  }
`;
const LoadingPlaceholder = () => {
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: '100%',
      height: '200px',
      padding: '16px',
      display: 'flex',
      alignItems: 'center',
      justifyContent: 'center'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, {
    size: "xl"
  }));
};
const PropertiesTab = {
  id: 'properties',
  name: _i18n.i18n.translate('xpack.infra.nodeDetails.tabs.metadata.title', {
    defaultMessage: 'Metadata'
  }),
  content: TabComponent
};
exports.PropertiesTab = PropertiesTab;