"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProcessRow = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _common = require("@kbn/kibana-react-plugin/common");
var _useToggle = _interopRequireDefault(require("react-use/lib/useToggle"));
var _auto_sizer = require("../../../../../../../components/auto_sizer");
var _process_row_charts = require("./process_row_charts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ProcessRow = ({
  cells,
  item
}) => {
  const [isExpanded, toggle] = (0, _useToggle.default)(false);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTableRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
    isExpander: true,
    textOnly: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "infraProcessRowButton",
    iconType: isExpanded ? 'arrowDown' : 'arrowRight',
    "aria-expanded": isExpanded,
    onClick: toggle
  })), cells), /*#__PURE__*/_react.default.createElement(_eui.EuiTableRow, {
    isExpandable: true,
    isExpandedRow: isExpanded
  }, isExpanded && /*#__PURE__*/_react.default.createElement(_auto_sizer.AutoSizer, {
    bounds: true
  }, ({
    measureRef,
    bounds: {
      height = 0
    }
  }) => /*#__PURE__*/_react.default.createElement(ExpandedRowCell, {
    commandHeight: height
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(ExpandedRowDescriptionList, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement("div", {
    ref: measureRef
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, _i18n.i18n.translate('xpack.infra.metrics.nodeDetails.processes.expandedRowLabelCommand', {
    defaultMessage: 'Command'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, /*#__PURE__*/_react.default.createElement(ExpandedCommandLine, null, item.command)))), item.apmTrace && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "infraProcessRowViewTraceInApmButton"
  }, _i18n.i18n.translate('xpack.infra.metrics.nodeDetails.processes.viewTraceInAPM', {
    defaultMessage: 'View trace in APM'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 2,
    gutterSize: "s",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, _i18n.i18n.translate('xpack.infra.metrics.nodeDetails.processes.expandedRowLabelPID', {
    defaultMessage: 'PID'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, /*#__PURE__*/_react.default.createElement(CodeListItem, null, item.pid))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, _i18n.i18n.translate('xpack.infra.metrics.nodeDetails.processes.expandedRowLabelUser', {
    defaultMessage: 'User'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, /*#__PURE__*/_react.default.createElement(CodeListItem, null, item.user))), /*#__PURE__*/_react.default.createElement(_process_row_charts.ProcessRowCharts, {
    command: item.command
  })))))));
};
exports.ProcessRow = ProcessRow;
const ExpandedRowDescriptionList = (0, _common.euiStyled)(_eui.EuiDescriptionList).attrs({
  compressed: true
})`
  width: 100%;
`;
const CodeListItem = (0, _common.euiStyled)(_eui.EuiCode).attrs({
  transparentBackground: true
})`
  padding: 0 !important;
  & code.euiCodeBlock__code {
    white-space: nowrap !important;
    vertical-align: middle;
  }
`;
const ExpandedCommandLine = (0, _common.euiStyled)(_eui.EuiCode).attrs({
  transparentBackground: true
})`
  padding: 0 !important;
  margin-bottom: ${props => props.theme.eui.euiSizeS};
`;
const ExpandedRowCell = (0, _common.euiStyled)(_eui.EuiTableRowCell).attrs({
  textOnly: false,
  colSpan: 6
})`
  height: ${props => props.commandHeight + 240}px;
  padding: 0 ${props => props.theme.eui.euiSizeM};
  background-color: ${props => props.theme.eui.euiColorLightestShade};
`;