"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimeDropdown = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TimeDropdown = props => /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
  "data-test-subj": "infraTimeDropdownSelect",
  fullWidth: true,
  options: [{
    text: _i18n.i18n.translate('xpack.infra.nodeDetails.metrics.last15Minutes', {
      defaultMessage: 'Last 15 minutes'
    }),
    value: 15 * 60 * 1000
  }, {
    text: _i18n.i18n.translate('xpack.infra.nodeDetails.metrics.lastHour', {
      defaultMessage: 'Last hour'
    }),
    value: 60 * 60 * 1000
  }, {
    text: _i18n.i18n.translate('xpack.infra.nodeDetails.metrics.last3Hours', {
      defaultMessage: 'Last 3 hours'
    }),
    value: 3 * 60 * 60 * 1000
  }, {
    text: _i18n.i18n.translate('xpack.infra.nodeDetails.metrics.last24Hours', {
      defaultMessage: 'Last 24 hours'
    }),
    value: 24 * 60 * 60 * 1000
  }, {
    text: _i18n.i18n.translate('xpack.infra.nodeDetails.metrics.last7Days', {
      defaultMessage: 'Last 7 days'
    }),
    value: 7 * 24 * 60 * 60 * 1000
  }],
  value: props.value,
  onChange: props.onChange
});
exports.TimeDropdown = TimeDropdown;