"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogsTab = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _useDebounce = _interopRequireDefault(require("react-use/lib/useDebounce"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _public = require("@kbn/observability-plugin/public");
var _shared = require("./shared");
var _log_stream = require("../../../../../../components/log_stream");
var _use_waffle_options = require("../../../hooks/use_waffle_options");
var _inventory_models = require("../../../../../../../common/inventory_models");
var _link_to = require("../../../../../link_to");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TabComponent = props => {
  const [textQuery, setTextQuery] = (0, _react.useState)('');
  const [textQueryDebounced, setTextQueryDebounced] = (0, _react.useState)('');
  const endTimestamp = props.currentTime;
  const startTimestamp = endTimestamp - 60 * 60 * 1000; // 60 minutes
  const {
    nodeType
  } = (0, _use_waffle_options.useWaffleOptionsContext)();
  const {
    node
  } = props;
  (0, _useDebounce.default)(() => setTextQueryDebounced(textQuery), textQueryThrottleInterval, [textQuery]);
  const filter = (0, _react.useMemo)(() => {
    const query = [`${(0, _inventory_models.findInventoryFields)(nodeType).id}: "${node.id}"`, ...(textQueryDebounced !== '' ? [textQueryDebounced] : [])].join(' and ');
    return {
      language: 'kuery',
      query
    };
  }, [nodeType, node.id, textQueryDebounced]);
  const onQueryChange = (0, _react.useCallback)(e => {
    setTextQuery(e.target.value);
  }, []);
  const nodeLogsMenuItemLinkProps = (0, _public.useLinkProps)((0, _link_to.getNodeLogsUrl)({
    nodeType,
    nodeId: node.id,
    time: startTimestamp
  }));
  return /*#__PURE__*/_react.default.createElement(_shared.TabContent, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: 'm',
    alignItems: 'center',
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    "data-test-subj": "infraTabComponentFieldSearch",
    fullWidth: true,
    placeholder: _i18n.i18n.translate('xpack.infra.nodeDetails.logs.textFieldPlaceholder', {
      defaultMessage: 'Search for log entries...'
    }),
    value: textQuery,
    isClearable: true,
    onChange: onQueryChange
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, (0, _extends2.default)({
    "data-test-subj": "infraTabComponentOpenInLogsButton",
    size: 'xs',
    flush: 'both',
    iconType: 'popout'
  }, nodeLogsMenuItemLinkProps), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.nodeDetails.logs.openLogsLink",
    defaultMessage: "Open in Logs"
  })))), /*#__PURE__*/_react.default.createElement(_log_stream.LogStream, {
    logView: {
      type: 'log-view-reference',
      logViewId: 'default'
    },
    startTimestamp: startTimestamp,
    endTimestamp: endTimestamp,
    query: filter
  }));
};
const LogsTab = {
  id: 'logs',
  name: _i18n.i18n.translate('xpack.infra.nodeDetails.tabs.logs', {
    defaultMessage: 'Logs'
  }),
  content: TabComponent
};
exports.LogsTab = LogsTab;
const textQueryThrottleInterval = 1000; // milliseconds