"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnomaliesTab = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _anomalies_table = require("../../../ml/anomaly_detection/anomalies_table/anomalies_table");
var _shared = require("../shared");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TabComponent = props => {
  const {
    node,
    onClose
  } = props;
  return /*#__PURE__*/_react.default.createElement(_shared.TabContent, null, /*#__PURE__*/_react.default.createElement(_anomalies_table.AnomaliesTable, {
    closeFlyout: onClose,
    hostName: node.name
  }));
};
const AnomaliesTab = {
  id: 'anomalies',
  name: _i18n.i18n.translate('xpack.infra.nodeDetails.tabs.anomalies', {
    defaultMessage: 'Anomalies'
  }),
  content: TabComponent
};
exports.AnomaliesTab = AnomaliesTab;