"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Layout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _useInterval = _interopRequireDefault(require("react-use/lib/useInterval"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _common = require("@kbn/kibana-react-plugin/common");
var _i18n = require("@kbn/i18n");
var _useLocalStorage = _interopRequireDefault(require("react-use/lib/useLocalStorage"));
var _auto_sizer = require("../../../../components/auto_sizer");
var _nodes_overview = require("./nodes_overview");
var _calculate_bounds_from_nodes = require("../lib/calculate_bounds_from_nodes");
var _page = require("../../../../components/page");
var _use_waffle_time = require("../hooks/use_waffle_time");
var _use_waffle_filters = require("../hooks/use_waffle_filters");
var _use_waffle_options = require("../hooks/use_waffle_options");
var _lib = require("../../../../lib/lib");
var _toolbar = require("./toolbars/toolbar");
var _view_switcher = require("./waffle/view_switcher");
var _create_inventory_metric_formatter = require("../lib/create_inventory_metric_formatter");
var _create_legend = require("../lib/create_legend");
var _use_waffle_view_state = require("../hooks/use_waffle_view_state");
var _bottom_drawer = require("./bottom_drawer");
var _legend_controls = require("./waffle/legend_controls");
var _try_it_button = require("../../../../components/try_it_button");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HOSTS_LINK_LOCAL_STORAGE_KEY = 'inventoryUI:hostsLinkClicked';
const Layout = /*#__PURE__*/_react.default.memo(({
  shouldLoadDefault,
  currentView,
  reload,
  interval,
  nodes,
  loading
}) => {
  var _legend$palette, _legend$steps, _legend$reverseColors;
  const [showLoading, setShowLoading] = (0, _react.useState)(true);
  const {
    metric,
    groupBy,
    sort,
    nodeType,
    changeView,
    view,
    autoBounds,
    boundsOverride,
    legend,
    changeBoundsOverride,
    changeAutoBounds,
    changeLegend
  } = (0, _use_waffle_options.useWaffleOptionsContext)();
  const {
    currentTime,
    jumpToTime,
    isAutoReloading
  } = (0, _use_waffle_time.useWaffleTimeContext)();
  const {
    applyFilterQuery
  } = (0, _use_waffle_filters.useWaffleFiltersContext)();
  const legendPalette = (_legend$palette = legend === null || legend === void 0 ? void 0 : legend.palette) !== null && _legend$palette !== void 0 ? _legend$palette : _use_waffle_options.DEFAULT_LEGEND.palette;
  const legendSteps = (_legend$steps = legend === null || legend === void 0 ? void 0 : legend.steps) !== null && _legend$steps !== void 0 ? _legend$steps : _use_waffle_options.DEFAULT_LEGEND.steps;
  const legendReverseColors = (_legend$reverseColors = legend === null || legend === void 0 ? void 0 : legend.reverseColors) !== null && _legend$reverseColors !== void 0 ? _legend$reverseColors : _use_waffle_options.DEFAULT_LEGEND.reverseColors;
  const [hostsLinkClicked, setHostsLinkClicked] = (0, _useLocalStorage.default)(HOSTS_LINK_LOCAL_STORAGE_KEY, false);
  const hostsLinkClickedRef = (0, _react.useRef)(hostsLinkClicked);
  const options = {
    formatter: _lib.InfraFormatterType.percent,
    formatTemplate: '{{value}}',
    legend: (0, _create_legend.createLegend)(legendPalette, legendSteps, legendReverseColors),
    metric,
    sort,
    groupBy
  };
  (0, _useInterval.default)(() => {
    if (!loading) {
      jumpToTime(Date.now());
    }
  }, isAutoReloading ? 5000 : null);
  const dataBounds = (0, _calculate_bounds_from_nodes.calculateBoundsFromNodes)(nodes);
  const bounds = autoBounds ? dataBounds : boundsOverride;
  /* eslint-disable-next-line react-hooks/exhaustive-deps */
  const formatter = (0, _react.useCallback)((0, _create_inventory_metric_formatter.createInventoryMetricFormatter)(options.metric), [options.metric]);
  const {
    onViewChange
  } = (0, _use_waffle_view_state.useWaffleViewState)();
  (0, _react.useEffect)(() => {
    if (currentView) {
      onViewChange(currentView);
    }
  }, [currentView, onViewChange]);
  (0, _react.useEffect)(() => {
    // load snapshot data after default view loaded, unless we're not loading a view
    if (currentView != null || !shouldLoadDefault) {
      reload();
    }

    /**
     * INFO: why disable exhaustive-deps
     * We need to wait on the currentView not to be null because it is loaded async and could change the view state.
     * We don't actually need to watch the value of currentView though, since the view state will be synched up by the
     * changing params in the reload method so we should only "watch" the reload method.
     *
     * TODO: Should refactor this in the future to make it more clear where all the view state is coming
     * from and it's precedence [query params, localStorage, defaultView, out of the box view]
     */
    /* eslint-disable-next-line react-hooks/exhaustive-deps */
  }, [reload, shouldLoadDefault]);
  (0, _react.useEffect)(() => {
    setShowLoading(true);
  }, [options.metric, nodeType]);
  (0, _react.useEffect)(() => {
    const hasNodes = nodes && nodes.length;
    // Don't show loading screen when we're auto-reloading
    setShowLoading(!hasNodes);
  }, [nodes]);
  const handleLegendControlChange = (0, _react.useCallback)(opts => {
    changeBoundsOverride(opts.bounds);
    changeAutoBounds(opts.auto);
    changeLegend(opts.legend);
  }, [changeBoundsOverride, changeAutoBounds, changeLegend]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_page.PageContent, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(TopActionContainer, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_toolbar.Toolbar, {
    nodeType: nodeType,
    currentTime: currentTime
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    css: (0, _react2.css)`
                    margin: 0;
                    justify-content: flex-end;
                  `
  }, view === 'map' && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_legend_controls.LegendControls, {
    options: legend != null ? legend : _use_waffle_options.DEFAULT_LEGEND,
    dataBounds: dataBounds,
    bounds: bounds,
    autoBounds: autoBounds,
    boundsOverride: boundsOverride,
    onChange: handleLegendControlChange
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_view_switcher.ViewSwitcher, {
    view: view,
    onChange: changeView
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, !hostsLinkClickedRef.current && nodeType === 'host' && /*#__PURE__*/_react.default.createElement(_try_it_button.TryItButton, {
    "data-test-subj": "inventory-hostsView-link",
    label: _i18n.i18n.translate('xpack.infra.layout.hostsLandingPageLink', {
      defaultMessage: 'Introducing a new Hosts analysis experience'
    }),
    link: {
      app: 'metrics',
      pathname: '/hosts'
    },
    experimental: true,
    onClick: () => {
      setHostsLinkClicked(true);
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: (0, _react2.css)`
                position: relative;
                flex: 1 1 auto;
              `
  }, /*#__PURE__*/_react.default.createElement(_auto_sizer.AutoSizer, {
    bounds: true
  }, ({
    bounds: {
      height = 0
    }
  }) => /*#__PURE__*/_react.default.createElement(_nodes_overview.NodesOverview, {
    nodes: nodes,
    options: options,
    nodeType: nodeType,
    loading: loading,
    showLoading: showLoading,
    reload: reload,
    onDrilldown: applyFilterQuery,
    currentTime: currentTime,
    view: view,
    autoBounds: autoBounds,
    boundsOverride: boundsOverride,
    formatter: formatter,
    bottomMargin: height
  }))))), /*#__PURE__*/_react.default.createElement(_bottom_drawer.BottomDrawer, {
    interval: interval,
    formatter: formatter,
    view: view,
    nodeType: nodeType
  }));
});
exports.Layout = Layout;
const TopActionContainer = (0, _common.euiStyled)(_eui.EuiFlexItem)`
  padding: ${props => `${props.theme.eui.euiSizeM} 0`};
`;