"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KubernetesTour = exports.KUBERNETES_TOUR_STORAGE_KEY = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _useLocalStorage = _interopRequireDefault(require("react-use/lib/useLocalStorage"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const KUBERNETES_TOUR_STORAGE_KEY = 'isKubernetesTourSeen';
exports.KUBERNETES_TOUR_STORAGE_KEY = KUBERNETES_TOUR_STORAGE_KEY;
const KubernetesTour = ({
  children
}) => {
  const [isTourSeen, setIsTourSeen] = (0, _useLocalStorage.default)(KUBERNETES_TOUR_STORAGE_KEY, false);
  const markTourAsSeen = () => setIsTourSeen(true);
  return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiTourStep, {
    content: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      color: "subdued",
      "data-test-subj": "infra-kubernetesTour-text"
    }, _i18n.i18n.translate('xpack.infra.homePage.kubernetesTour.text', {
      defaultMessage: 'Click here to see your infrastructure in different ways, including Kubernetes pods.'
    })),
    isStepOpen: !isTourSeen,
    maxWidth: 350,
    onFinish: markTourAsSeen,
    step: 1,
    stepsTotal: 1,
    title: _i18n.i18n.translate('xpack.infra.homePage.kubernetesTour.title', {
      defaultMessage: 'Want a different view?'
    }),
    anchorPosition: "downCenter",
    footerAction: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "infra-kubernetesTour-dismiss",
      size: "s",
      color: "text",
      onClick: markTourAsSeen
    }, _i18n.i18n.translate('xpack.infra.homePage.kubernetesTour.dismiss', {
      defaultMessage: 'Dismiss'
    }))
  }, children));
};
exports.KubernetesTour = KubernetesTour;