"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BottomDrawer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _common = require("@kbn/kibana-react-plugin/common");
var _public = require("@kbn/observability-plugin/public");
var _useLocalStorage = _interopRequireDefault(require("react-use/lib/useLocalStorage"));
var _try_it_button = require("../../../../components/try_it_button");
var _use_waffle_options = require("../hooks/use_waffle_options");
var _timeline = require("./timeline/timeline");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const showHistory = _i18n.i18n.translate('xpack.infra.showHistory', {
  defaultMessage: 'Show history'
});
const hideHistory = _i18n.i18n.translate('xpack.infra.hideHistory', {
  defaultMessage: 'Hide history'
});
const LOCAL_STORAGE_KEY = 'inventoryUI:k8sDashboardClicked';
const KubernetesButton = () => {
  const [clicked, setClicked] = (0, _useLocalStorage.default)(LOCAL_STORAGE_KEY, false);
  const clickedRef = (0, _react.useRef)(clicked);
  return /*#__PURE__*/_react.default.createElement(_try_it_button.TryItButton, {
    color: clickedRef.current ? 'primary' : 'accent',
    label: _i18n.i18n.translate('xpack.infra.bottomDrawer.kubernetesDashboardsLink', {
      defaultMessage: 'Kubernetes dashboards'
    }),
    "data-test-subj": "inventory-kubernetesDashboard-link",
    link: {
      app: 'dashboards',
      hash: '/list',
      search: {
        _g: '()',
        s: 'kubernetes tag:(Managed)'
      }
    },
    onClick: () => {
      if (!clickedRef.current) {
        setClicked(true);
      }
    },
    hideBadge: clickedRef.current
  });
};
const BottomDrawer = ({
  interval,
  formatter,
  view,
  nodeType
}) => {
  const {
    timelineOpen,
    changeTimelineOpen
  } = (0, _use_waffle_options.useWaffleOptionsContext)();
  const [isOpen, setIsOpen] = (0, _react.useState)(Boolean(timelineOpen));
  (0, _react.useEffect)(() => {
    if (isOpen !== timelineOpen) setIsOpen(Boolean(timelineOpen));
  }, [isOpen, timelineOpen]);
  const trackDrawerOpen = (0, _public.useUiTracker)({
    app: 'infra_metrics'
  });
  const onClick = (0, _react.useCallback)(() => {
    if (!isOpen) trackDrawerOpen({
      metric: 'open_timeline_drawer__inventory'
    });
    setIsOpen(!isOpen);
    changeTimelineOpen(!isOpen);
  }, [isOpen, trackDrawerOpen, changeTimelineOpen]);
  if (view === 'table') {
    return nodeType === 'pod' ? /*#__PURE__*/_react.default.createElement(BottomPanel, {
      hasBorder: false,
      hasShadow: false,
      borderRadius: "none",
      paddingSize: "s"
    }, /*#__PURE__*/_react.default.createElement(KubernetesButton, null)) : null;
  }
  return /*#__PURE__*/_react.default.createElement(BottomActionContainer, null, /*#__PURE__*/_react.default.createElement(StickyPanel, {
    borderRadius: "none",
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    justifyContent: "flexStart",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "aria-expanded": isOpen,
    iconType: isOpen ? 'arrowDown' : 'arrowRight',
    onClick: onClick,
    "data-test-subj": "toggleTimelineButton"
  }, isOpen ? hideHistory : showHistory)), nodeType === 'pod' && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(KubernetesButton, null)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    style: {
      maxHeight: isOpen ? '224px' : 0,
      transition: 'max-height 0.15s ease',
      overflow: 'hidden'
    }
  }, /*#__PURE__*/_react.default.createElement(_timeline.Timeline, {
    isVisible: isOpen,
    interval: interval,
    yAxisFormatter: formatter
  })));
};
exports.BottomDrawer = BottomDrawer;
const BottomActionContainer = _common.euiStyled.div`
  position: sticky;
  bottom: 0;
  left: 0;
  background: ${props => props.theme.eui.euiColorGhost};
  width: calc(100% + ${props => props.theme.eui.euiSizeL} * 2);
  margin-left: -${props => props.theme.eui.euiSizeL};
`; // Additional width comes from the padding on the EuiPageBody and inner nodes container

const BottomPanel = (0, _common.euiStyled)(_eui.EuiPanel)`
  padding: ${props => props.theme.eui.euiSizeL} 0;
`;
const StickyPanel = (0, _common.euiStyled)(_eui.EuiPanel)`
  padding: 0 ${props => props.theme.eui.euiSizeL};
`;